/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.event;

import com.alibaba.nacos.api.naming.listener.AbstractEventListener;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.event.InstancesChangeEvent;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InstancesChangeNotifier
extends Subscriber<InstancesChangeEvent> {
    private final String eventScope;
    private final Map<String, ConcurrentHashSet<EventListener>> listenerMap = new ConcurrentHashMap<String, ConcurrentHashSet<EventListener>>();
    private final Object lock = new Object();

    public InstancesChangeNotifier(String eventScope) {
        this.eventScope = eventScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(String serviceName, String clusters, EventListener listener) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        ConcurrentHashSet eventListeners = this.listenerMap.get(key);
        if (eventListeners == null) {
            Object object = this.lock;
            synchronized (object) {
                eventListeners = this.listenerMap.get(key);
                if (eventListeners == null) {
                    eventListeners = new ConcurrentHashSet();
                    this.listenerMap.put(key, (ConcurrentHashSet<EventListener>)eventListeners);
                }
            }
        }
        eventListeners.add((Object)listener);
    }

    public void deregisterListener(String serviceName, String clusters, EventListener listener) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        ConcurrentHashSet<EventListener> eventListeners = this.listenerMap.get(key);
        if (eventListeners == null) {
            return;
        }
        eventListeners.remove((Object)listener);
        if (CollectionUtils.isEmpty(eventListeners)) {
            this.listenerMap.remove(key);
        }
    }

    public boolean isSubscribed(String serviceName, String clusters) {
        String key = ServiceInfo.getKey((String)serviceName, (String)clusters);
        ConcurrentHashSet<EventListener> eventListeners = this.listenerMap.get(key);
        return CollectionUtils.isNotEmpty(eventListeners);
    }

    public List<ServiceInfo> getSubscribeServices() {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        for (String key : this.listenerMap.keySet()) {
            serviceInfos.add(ServiceInfo.fromKey((String)key));
        }
        return serviceInfos;
    }

    public void onEvent(InstancesChangeEvent event) {
        String key = ServiceInfo.getKey((String)event.getServiceName(), (String)event.getClusters());
        ConcurrentHashSet<EventListener> eventListeners = this.listenerMap.get(key);
        if (CollectionUtils.isEmpty(eventListeners)) {
            return;
        }
        for (final EventListener listener : eventListeners) {
            final Event namingEvent = this.transferToNamingEvent(event);
            if (listener instanceof AbstractEventListener && ((AbstractEventListener)listener).getExecutor() != null) {
                ((AbstractEventListener)listener).getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onEvent(namingEvent);
                    }
                });
                continue;
            }
            listener.onEvent(namingEvent);
        }
    }

    private Event transferToNamingEvent(InstancesChangeEvent instancesChangeEvent) {
        return new NamingEvent(instancesChangeEvent.getServiceName(), instancesChangeEvent.getGroupName(), instancesChangeEvent.getClusters(), instancesChangeEvent.getHosts());
    }

    public Class<? extends com.alibaba.nacos.common.notify.Event> subscribeType() {
        return InstancesChangeEvent.class;
    }

    public boolean scopeMatches(InstancesChangeEvent event) {
        return this.eventScope.equals(event.scope());
    }
}

