/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.controller;

import javax.annotation.Resource;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.server.console.entity.param.GlobalLockParam;
import org.apache.seata.server.console.entity.vo.GlobalLockVO;
import org.apache.seata.server.console.service.GlobalLockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/console/globalLock"})
public class GlobalLockController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalLockController.class);
    @Resource(type=GlobalLockService.class)
    private GlobalLockService globalLockService;

    @GetMapping(value={"query"})
    public PageResult<GlobalLockVO> query(@ModelAttribute GlobalLockParam param) {
        return this.globalLockService.query(param);
    }

    @DeleteMapping(value={"delete"})
    public SingleResult<Void> delete(@ModelAttribute GlobalLockParam param) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to delete the global lock, param: {}", (Object)param);
        }
        return this.globalLockService.deleteLock(param);
    }

    @GetMapping(value={"check"})
    public SingleResult<Boolean> check(String xid, String branchId) {
        return this.globalLockService.check(xid, branchId);
    }
}

