/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.controller;

import javax.annotation.Resource;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.server.console.service.BranchSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/console/branchSession"})
public class BranchSessionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BranchSessionController.class);
    @Resource(type=BranchSessionService.class)
    private BranchSessionService branchSessionService;

    @DeleteMapping(value={"deleteBranchSession"})
    public SingleResult<Void> deleteBranchSession(String xid, String branchId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to delete the branch session, xid: {} branchId: {}", (Object)xid, (Object)branchId);
        }
        return this.branchSessionService.deleteBranchSession(xid, branchId);
    }

    @DeleteMapping(value={"forceDeleteBranchSession"})
    public SingleResult<Void> forceDeleteBranchSession(String xid, String branchId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to delete the branch session, xid: {} branchId: {}", (Object)xid, (Object)branchId);
        }
        return this.branchSessionService.forceDeleteBranchSession(xid, branchId);
    }

    @PutMapping(value={"stopBranchSession"})
    public SingleResult<Void> stopBranchSession(String xid, String branchId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to stop the branch session, xid: {} branchId: {}", (Object)xid, (Object)branchId);
        }
        return this.branchSessionService.stopBranchRetry(xid, branchId);
    }

    @PutMapping(value={"startBranchSession"})
    public SingleResult<Void> startBranchRetry(String xid, String branchId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to start the branch session, xid: {} branchId: {}", (Object)xid, (Object)branchId);
        }
        return this.branchSessionService.startBranchRetry(xid, branchId);
    }
}

