/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.snapshot.metadata;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.snapshot.RaftSnapshot;
import org.apache.seata.server.cluster.raft.snapshot.StoreSnapshotFile;
import org.apache.seata.server.cluster.raft.sync.msg.dto.RaftClusterMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderMetadataSnapshotFile
implements Serializable,
StoreSnapshotFile {
    private static final long serialVersionUID = 78637164618855724L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderMetadataSnapshotFile.class);
    private final String group;
    private final String fileName = "leader_metadata";

    public LeaderMetadataSnapshotFile(String group) {
        this.group = group;
    }

    public Status save(SnapshotWriter writer) {
        RaftSnapshot raftSnapshot = new RaftSnapshot();
        RaftClusterMetadata raftClusterMetadata = RaftServerManager.getRaftServer((String)this.group).getRaftStateMachine().getRaftLeaderMetadata();
        raftSnapshot.setBody((Object)raftClusterMetadata);
        raftSnapshot.setType(RaftSnapshot.SnapshotType.leader_metadata);
        String path = writer.getPath() + File.separator + "leader_metadata";
        try {
            if (this.save(raftSnapshot, path)) {
                if (writer.addFile("leader_metadata")) {
                    return Status.OK();
                }
                return new Status(RaftError.EIO, "Fail to add file to writer", new Object[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("Fail to save groupId: {} snapshot {}", new Object[]{this.group, path, e});
        }
        return new Status(RaftError.EIO, "Fail to save groupId: " + this.group + " snapshot %s", new Object[]{path});
    }

    public boolean load(SnapshotReader reader) {
        if (reader.getFileMeta("leader_metadata") == null) {
            LOGGER.error("Fail to find data file in {}", (Object)reader.getPath());
            return false;
        }
        String path = reader.getPath() + File.separator + "leader_metadata";
        try {
            RaftClusterMetadata raftClusterMetadata = (RaftClusterMetadata)this.load(path);
            RaftServerManager.getRaftServer((String)this.group).getRaftStateMachine().setRaftLeaderMetadata(raftClusterMetadata);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("fail to load snapshot from {}", (Object)path, (Object)e);
            return false;
        }
    }
}

