/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.exception.ErrorCode;
import org.apache.seata.common.exception.SeataRuntimeException;

public class CustomDeserializer
extends JsonDeserializer<Class<?>> {
    String oldPackage = "io.seata.server";
    String currentPackage = "org.apache.seata.server";
    private static final List<String> PERMIT_PACKAGES = new ArrayList();

    public Class<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String className = jsonParser.getValueAsString();
        if (className.startsWith(this.oldPackage)) {
            className = className.replaceFirst(this.oldPackage, this.currentPackage);
        }
        for (String permitPackage : PERMIT_PACKAGES) {
            if (!className.startsWith(permitPackage)) continue;
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new SeataRuntimeException(ErrorCode.ERR_DESERIALIZATION_SECURITY, new String[]{"Failed to deserialize object: " + className + " is not permitted"});
    }

    static {
        PERMIT_PACKAGES.add("org.apache.seata");
        PERMIT_PACKAGES.add("java.util.HashMap");
    }
}

