/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class ServerRunner
implements CommandLineRunner,
DisposableBean,
ApplicationListener<ApplicationEvent>,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerRunner.class);
    private boolean started = Boolean.FALSE;
    private int port;
    @Value(value="${logging.file.path}")
    private String logPath;
    private static final List<Disposable> DISPOSABLE_LIST = new CopyOnWriteArrayList();
    @Resource
    Server seataServer;

    public static void addDisposable(Disposable disposable) {
        DISPOSABLE_LIST.add(disposable);
    }

    public void run(String ... args) {
        try {
            long start = System.currentTimeMillis();
            this.seataServer.start(args);
            this.started = true;
            long cost = System.currentTimeMillis() - start;
            LOGGER.info("\r\n you can visit seata console UI on namingserver. \r\n log path: {}.", (Object)this.logPath);
            LOGGER.info("seata server started in {} millSeconds", (Object)cost);
        }
        catch (Throwable e) {
            this.started = Boolean.FALSE;
            LOGGER.error("seata server start error: {} ", (Object)e.getMessage(), (Object)e);
            System.exit(-1);
        }
    }

    public boolean started() {
        return this.started;
    }

    public void destroy() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destoryAll starting");
        }
        for (Disposable disposable : DISPOSABLE_LIST) {
            disposable.destroy();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destoryAll finish");
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof WebServerInitializedEvent) {
            this.port = ((WebServerInitializedEvent)event).getWebServer().getPort();
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

