/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.ChannelDecorator;
import org.apache.skywalking.apm.dependencies.io.grpc.CallOptions;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.ClientCall;
import org.apache.skywalking.apm.dependencies.io.grpc.ClientInterceptor;
import org.apache.skywalking.apm.dependencies.io.grpc.ClientInterceptors;
import org.apache.skywalking.apm.dependencies.io.grpc.ForwardingClientCall;
import org.apache.skywalking.apm.dependencies.io.grpc.Metadata;
import org.apache.skywalking.apm.dependencies.io.grpc.MethodDescriptor;

public class AgentIDDecorator
implements ChannelDecorator {
    private static final ILog LOGGER = LogManager.getLogger(AgentIDDecorator.class);
    private static final Metadata.Key<String> AGENT_VERSION_HEAD_HEADER_NAME = Metadata.Key.of("Agent-Version", Metadata.ASCII_STRING_MARSHALLER);
    private String version = "UNKNOWN";

    public AgentIDDecorator() {
        try {
            Enumeration<URL> resources = AgentIDDecorator.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest;
                    Attributes mainAttribs;
                    String projectName;
                    if (is == null || (projectName = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue("Implementation-Vendor-Id")) == null || !"org.apache.skywalking".equals(projectName)) continue;
                    this.version = mainAttribs.getValue("Implementation-Version");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't read version from MANIFEST.MF in the agent jar", new Object[0]);
        }
    }

    @Override
    public Channel build(Channel channel) {
        return ClientInterceptors.intercept(channel, new ClientInterceptor(){

            public <REQ, RESP> ClientCall<REQ, RESP> interceptCall(MethodDescriptor<REQ, RESP> method, CallOptions options, Channel channel) {
                return new ForwardingClientCall.SimpleForwardingClientCall<REQ, RESP>(channel.newCall(method, options)){

                    @Override
                    public void start(ClientCall.Listener<RESP> responseListener, Metadata headers) {
                        headers.put(AGENT_VERSION_HEAD_HEADER_NAME, AgentIDDecorator.this.version);
                        super.start(responseListener, headers);
                    }
                };
            }
        });
    }
}

