/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.meta;

import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.meta.MetaCompressor;

class TypeEqualMetaCompressor
implements MetaCompressor {
    private static final Logger LOG = LoggerFactory.getLogger(TypeEqualMetaCompressor.class);
    private final MetaCompressor compressor;

    public TypeEqualMetaCompressor(MetaCompressor compressor) {
        this.compressor = compressor;
        LOG.warn("{} should implement equals/hashCode method, otherwise compile cache may won't work. Use type to check MetaCompressor identity instead, but thismay be incorrect if different compressor instance of same type indicates different compressor.", (Object)compressor);
    }

    @Override
    public byte[] compress(byte[] data, int offset, int size) {
        return this.compressor.compress(data, offset, size);
    }

    @Override
    public byte[] decompress(byte[] data, int offset, int size) {
        return this.compressor.decompress(data, offset, size);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.compressor.getClass().equals(((TypeEqualMetaCompressor)obj).compressor.getClass());
    }

    public int hashCode() {
        return this.compressor.getClass().hashCode();
    }
}

