/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.kv;

import com.ecwid.consul.ConsulException;
import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.KeyValueClient;
import com.ecwid.consul.v1.kv.model.GetBinaryValue;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import com.google.gson.reflect.TypeToken;
import java.util.List;

public final class KeyValueConsulClient
implements KeyValueClient {
    private final ConsulRawClient rawClient;

    public KeyValueConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    public KeyValueConsulClient() {
        this(new ConsulRawClient());
    }

    public KeyValueConsulClient(String agentHost) {
        this(new ConsulRawClient(agentHost));
    }

    public KeyValueConsulClient(String agentHost, int agentPort) {
        this(new ConsulRawClient(agentHost, agentPort));
    }

    public KeyValueConsulClient(TLSConfig tlsConfig) {
        this(new ConsulRawClient(tlsConfig));
    }

    public KeyValueConsulClient(String agentHost, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, tlsConfig));
    }

    public KeyValueConsulClient(String agentHost, int agentPort, TLSConfig tlsConfig) {
        this(new ConsulRawClient(agentHost, agentPort, tlsConfig));
    }

    @Override
    public Response<GetValue> getKVValue(String key) {
        return this.getKVValue(key, QueryParams.DEFAULT);
    }

    @Override
    public Response<GetValue> getKVValue(String key, String token) {
        return this.getKVValue(key, token, QueryParams.DEFAULT);
    }

    @Override
    public Response<GetValue> getKVValue(String key, QueryParams queryParams) {
        return this.getKVValue(key, null, queryParams);
    }

    @Override
    public Response<GetValue> getKVValue(String key, String token, QueryParams queryParams) {
        SingleUrlParameters tokenParams = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/kv/" + key, tokenParams, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<GetValue>>(){}.getType());
            if (value.size() == 0) {
                return new Response<Object>(null, rawResponse);
            }
            if (value.size() == 1) {
                return new Response<GetValue>((GetValue)value.get(0), rawResponse);
            }
            throw new ConsulException("Strange response (list size=" + value.size() + ")");
        }
        if (rawResponse.getStatusCode() == 404) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key) {
        return this.getKVBinaryValue(key, QueryParams.DEFAULT);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key, String token) {
        return this.getKVBinaryValue(key, token, QueryParams.DEFAULT);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key, QueryParams queryParams) {
        return this.getKVBinaryValue(key, null, queryParams);
    }

    @Override
    public Response<GetBinaryValue> getKVBinaryValue(String key, String token, QueryParams queryParams) {
        SingleUrlParameters tokenParams = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/kv/" + key, tokenParams, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<GetBinaryValue>>(){}.getType());
            if (value.size() == 0) {
                return new Response<Object>(null, rawResponse);
            }
            if (value.size() == 1) {
                return new Response<GetBinaryValue>((GetBinaryValue)value.get(0), rawResponse);
            }
            throw new ConsulException("Strange response (list size=" + value.size() + ")");
        }
        if (rawResponse.getStatusCode() == 404) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix) {
        return this.getKVValues(keyPrefix, QueryParams.DEFAULT);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix, String token) {
        return this.getKVValues(keyPrefix, token, QueryParams.DEFAULT);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix, QueryParams queryParams) {
        return this.getKVValues(keyPrefix, null, queryParams);
    }

    @Override
    public Response<List<GetValue>> getKVValues(String keyPrefix, String token, QueryParams queryParams) {
        SingleUrlParameters recurseParam = new SingleUrlParameters("recurse");
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/kv/" + keyPrefix, recurseParam, tokenParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<GetValue>>(){}.getType());
            return new Response<List<GetValue>>(value, rawResponse);
        }
        if (rawResponse.getStatusCode() == 404) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix) {
        return this.getKVBinaryValues(keyPrefix, QueryParams.DEFAULT);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix, String token) {
        return this.getKVBinaryValues(keyPrefix, token, QueryParams.DEFAULT);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix, QueryParams queryParams) {
        return this.getKVBinaryValues(keyPrefix, null, queryParams);
    }

    @Override
    public Response<List<GetBinaryValue>> getKVBinaryValues(String keyPrefix, String token, QueryParams queryParams) {
        SingleUrlParameters recurseParam = new SingleUrlParameters("recurse");
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/kv/" + keyPrefix, recurseParam, tokenParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<GetBinaryValue>>(){}.getType());
            return new Response<List<GetBinaryValue>>(value, rawResponse);
        }
        if (rawResponse.getStatusCode() == 404) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix) {
        return this.getKVKeysOnly(keyPrefix, QueryParams.DEFAULT);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix, String separator, String token) {
        return this.getKVKeysOnly(keyPrefix, separator, token, QueryParams.DEFAULT);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix, QueryParams queryParams) {
        return this.getKVKeysOnly(keyPrefix, null, null, queryParams);
    }

    @Override
    public Response<List<String>> getKVKeysOnly(String keyPrefix, String separator, String token, QueryParams queryParams) {
        SingleUrlParameters keysParam = new SingleUrlParameters("keys");
        SingleUrlParameters separatorParam = separator != null ? new SingleUrlParameters("separator", separator) : null;
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/kv/" + keyPrefix, keysParam, separatorParam, tokenParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<String>>(){}.getType());
            return new Response<List<String>>(value, rawResponse);
        }
        if (rawResponse.getStatusCode() == 404) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value) {
        return this.setKVValue(key, value, QueryParams.DEFAULT);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, PutParams putParams) {
        return this.setKVValue(key, value, putParams, QueryParams.DEFAULT);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, String token, PutParams putParams) {
        return this.setKVValue(key, value, token, putParams, QueryParams.DEFAULT);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, QueryParams queryParams) {
        return this.setKVValue(key, value, null, null, queryParams);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, PutParams putParams, QueryParams queryParams) {
        return this.setKVValue(key, value, null, putParams, queryParams);
    }

    @Override
    public Response<Boolean> setKVValue(String key, String value, String token, PutParams putParams, QueryParams queryParams) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/kv/" + key, value, putParams, tokenParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            boolean result = (Boolean)GsonFactory.getGson().fromJson(rawResponse.getContent(), Boolean.TYPE);
            return new Response<Boolean>(result, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value) {
        return this.setKVBinaryValue(key, value, QueryParams.DEFAULT);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, PutParams putParams) {
        return this.setKVBinaryValue(key, value, putParams, QueryParams.DEFAULT);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, String token, PutParams putParams) {
        return this.setKVBinaryValue(key, value, token, putParams, QueryParams.DEFAULT);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, QueryParams queryParams) {
        return this.setKVBinaryValue(key, value, null, null, queryParams);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, PutParams putParams, QueryParams queryParams) {
        return this.setKVBinaryValue(key, value, null, putParams, queryParams);
    }

    @Override
    public Response<Boolean> setKVBinaryValue(String key, byte[] value, String token, PutParams putParams, QueryParams queryParams) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/kv/" + key, value, putParams, tokenParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            boolean result = (Boolean)GsonFactory.getGson().fromJson(rawResponse.getContent(), Boolean.TYPE);
            return new Response<Boolean>(result, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> deleteKVValue(String key) {
        return this.deleteKVValue(key, QueryParams.DEFAULT);
    }

    @Override
    public Response<Void> deleteKVValue(String key, String token) {
        return this.deleteKVValue(key, token, QueryParams.DEFAULT);
    }

    @Override
    public Response<Void> deleteKVValue(String key, QueryParams queryParams) {
        return this.deleteKVValue(key, null, queryParams);
    }

    @Override
    public Response<Void> deleteKVValue(String key, String token, QueryParams queryParams) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeDeleteRequest("/v1/kv/" + key, tokenParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> deleteKVValues(String key) {
        return this.deleteKVValues(key, QueryParams.DEFAULT);
    }

    @Override
    public Response<Void> deleteKVValues(String key, String token) {
        return this.deleteKVValues(key, token, QueryParams.DEFAULT);
    }

    @Override
    public Response<Void> deleteKVValues(String key, QueryParams queryParams) {
        return this.deleteKVValues(key, null, queryParams);
    }

    @Override
    public Response<Void> deleteKVValues(String key, String token, QueryParams queryParams) {
        SingleUrlParameters recurseParam = new SingleUrlParameters("recurse");
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeDeleteRequest("/v1/kv/" + key, tokenParam, recurseParam, queryParams);
        if (rawResponse.getStatusCode() == 200) {
            return new Response<Object>(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }
}

