/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.v0;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.apache.seata.core.protocol.HeartbeatMessage;
import org.apache.seata.core.protocol.MessageTypeAware;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.netty.ProtocolEncoder;
import org.apache.seata.core.rpc.netty.v0.ProtocolConstantsV0;
import org.apache.seata.core.rpc.netty.v0.ProtocolRpcMessageV0;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerServiceLoader;
import org.apache.seata.core.serializer.SerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolEncoderV0
extends MessageToByteEncoder
implements ProtocolEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolEncoderV0.class);

    @Override
    public void encode(RpcMessage message, ByteBuf out) {
        try {
            byte codec = message.getCodec();
            ProtocolRpcMessageV0 msg = new ProtocolRpcMessageV0();
            msg.rpcMsg2ProtocolMsg(message);
            out.writeShort((int)ProtocolConstantsV0.MAGIC);
            int flag = (msg.isAsync() ? 64 : 0) | (msg.isHeartbeat() ? 32 : 0) | (msg.isRequest() ? 128 : 0) | (msg.isSeataCodec() ? 16 : 0);
            out.writeShort((int)((short)flag));
            if (msg.getBody() instanceof HeartbeatMessage) {
                out.writeShort(0);
                out.writeLong(msg.getId());
                return;
            }
            byte[] bodyBytes = null;
            Serializer serializer = SerializerServiceLoader.load(SerializerType.getByCode(codec), (byte)0);
            bodyBytes = serializer.serialize(msg.getBody());
            if (msg.isSeataCodec()) {
                if (msg.getBody() instanceof MessageTypeAware) {
                    short typeCode = ((MessageTypeAware)msg.getBody()).getTypeCode();
                    out.writeShort((int)typeCode);
                }
            } else {
                out.writeShort(bodyBytes.length);
            }
            out.writeLong(msg.getId());
            if (bodyBytes != null) {
                out.writeBytes(bodyBytes);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Send:" + msg.getBody());
            }
        }
        catch (Throwable e) {
            LOGGER.error("Encode request error!", e);
        }
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        try {
            if (!(msg instanceof RpcMessage)) {
                throw new UnsupportedOperationException("Not support this class:" + msg.getClass());
            }
            this.encode((RpcMessage)msg, out);
        }
        catch (Throwable e) {
            LOGGER.error("Encode request error!", e);
        }
    }
}

