/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.util.Map;
import org.apache.seata.core.exception.DecodeException;
import org.apache.seata.core.protocol.ProtocolConstants;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.netty.ProtocolDecoder;
import org.apache.seata.core.rpc.netty.ProtocolEncoder;
import org.apache.seata.core.rpc.netty.v0.ProtocolDecoderV0;
import org.apache.seata.core.rpc.netty.v0.ProtocolEncoderV0;
import org.apache.seata.core.rpc.netty.v1.ProtocolDecoderV1;
import org.apache.seata.core.rpc.netty.v1.ProtocolEncoderV1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProtocolDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiProtocolDecoder.class);
    private final Map<Byte, ProtocolDecoder> protocolDecoderMap = ImmutableMap.builder().put((Object)0, (Object)new ProtocolDecoderV0()).put((Object)1, (Object)new ProtocolDecoderV1()).build();
    private final Map<Byte, ProtocolEncoder> protocolEncoderMap = ImmutableMap.builder().put((Object)0, (Object)new ProtocolEncoderV0()).put((Object)1, (Object)new ProtocolEncoderV1()).build();
    private final ChannelHandler[] channelHandlers;

    public MultiProtocolDecoder(ChannelHandler ... channelHandlers) {
        this(0x800000, channelHandlers);
    }

    public MultiProtocolDecoder() {
        this(0x800000, null);
    }

    public MultiProtocolDecoder(int maxFrameLength, ChannelHandler[] channelHandlers) {
        super(maxFrameLength, 3, 4, -7, 0);
        this.channelHandlers = channelHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        Object decoded;
        block13: {
            RpcMessage rpcMessage;
            ProtocolEncoder encoder;
            ProtocolDecoder decoder;
            block14: {
                byte version;
                if (this.isV0(in)) {
                    decoded = in;
                    version = 0;
                } else {
                    decoded = super.decode(ctx, in);
                    version = this.decideVersion(decoded);
                }
                if (!(decoded instanceof ByteBuf)) break block13;
                Object frame = decoded;
                decoder = this.protocolDecoderMap.get(version);
                if (decoder == null) {
                    LOGGER.error("Decoder not found, version={}, use current version({})", (Object)version, (Object)1);
                    decoder = this.protocolDecoderMap.get((byte)1);
                }
                if ((encoder = this.protocolEncoderMap.get(version)) == null) {
                    LOGGER.error("Encoder not found, version: {}, use current version({})", (Object)version, (Object)1);
                    encoder = this.protocolEncoderMap.get((byte)1);
                }
                try {
                    if (decoder == null || encoder == null) {
                        throw new UnsupportedOperationException("Unsupported version: " + version);
                    }
                    rpcMessage = decoder.decodeFrame((ByteBuf)frame);
                    if (version == 0) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (version != 0) {
                            frame.release();
                        }
                        ctx.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)decoder});
                        ctx.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)encoder});
                        if (this.channelHandlers != null) {
                            ctx.pipeline().addLast(this.channelHandlers);
                        }
                        ctx.pipeline().remove((ChannelHandler)this);
                        throw throwable;
                    }
                    catch (Exception exx) {
                        LOGGER.error("Decode frame error, cause: {}", (Object)exx.getMessage());
                        throw new DecodeException(exx);
                    }
                }
                frame.release();
            }
            ctx.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)decoder});
            ctx.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)encoder});
            if (this.channelHandlers != null) {
                ctx.pipeline().addLast(this.channelHandlers);
            }
            ctx.pipeline().remove((ChannelHandler)this);
            return rpcMessage;
        }
        return decoded;
    }

    protected byte decideVersion(Object in) {
        if (in instanceof ByteBuf) {
            ByteBuf frame = (ByteBuf)in;
            frame.markReaderIndex();
            byte b0 = frame.readByte();
            byte b1 = frame.readByte();
            if (ProtocolConstants.MAGIC_CODE_BYTES[0] != b0 || ProtocolConstants.MAGIC_CODE_BYTES[1] != b1) {
                throw new IllegalArgumentException("Unknown magic code: " + b0 + ", " + b1);
            }
            byte version = frame.readByte();
            frame.resetReaderIndex();
            return version;
        }
        return -1;
    }

    protected boolean isV0(ByteBuf in) {
        boolean isV0 = false;
        in.markReaderIndex();
        byte b0 = in.readByte();
        byte b1 = in.readByte();
        byte b2 = in.readByte();
        if (ProtocolConstants.MAGIC_CODE_BYTES[0] == b0 && ProtocolConstants.MAGIC_CODE_BYTES[1] == b1 && 0 == b2) {
            isV0 = true;
        }
        in.resetReaderIndex();
        return isV0;
    }

    protected boolean isV0(byte version) {
        return version == 0;
    }
}

