/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import org.apache.seata.core.rpc.netty.AbstractNettyRemotingClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ChannelEventHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelEventHandler.class);
    private final AbstractNettyRemotingClient remotingClient;

    public ChannelEventHandler(AbstractNettyRemotingClient remotingClient) {
        this.remotingClient = remotingClient;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Channel active: {}", (Object)ctx.channel().remoteAddress());
        }
        this.remotingClient.onChannelActive(ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        LOGGER.warn("Channel inactive: {}", (Object)channel.remoteAddress());
        this.remotingClient.onChannelInactive(channel);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        LOGGER.warn("Channel exception: {}, cause: {}", (Object)channel.remoteAddress(), (Object)cause.getMessage());
        this.remotingClient.onChannelException(channel, cause);
        super.exceptionCaught(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Channel idle: {}", (Object)ctx.channel().remoteAddress());
            }
            this.remotingClient.onChannelIdle(ctx.channel());
        }
        super.userEventTriggered(ctx, evt);
    }
}

