/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.lock;

import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.core.lock.Locker;
import org.apache.seata.core.lock.RowLock;
import org.apache.seata.core.store.LockDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocker
implements Locker {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractLocker.class);
    protected static final String LOCK_SPLIT = "^^^";

    protected List<LockDO> convertToLockDO(List<RowLock> locks) {
        ArrayList<LockDO> lockDOs = new ArrayList<LockDO>();
        if (CollectionUtils.isEmpty(locks)) {
            return lockDOs;
        }
        for (RowLock rowLock : locks) {
            LockDO lockDO = this.convertToLockDO(rowLock);
            lockDOs.add(lockDO);
        }
        return lockDOs;
    }

    protected LockDO convertToLockDO(RowLock rowLock) {
        LockDO lockDO = new LockDO();
        lockDO.setBranchId(rowLock.getBranchId());
        lockDO.setPk(rowLock.getPk());
        lockDO.setResourceId(rowLock.getResourceId());
        lockDO.setRowKey(this.getRowKey(rowLock.getResourceId(), rowLock.getTableName(), rowLock.getPk()));
        lockDO.setXid(rowLock.getXid());
        lockDO.setTransactionId(rowLock.getTransactionId());
        lockDO.setTableName(rowLock.getTableName());
        return lockDO;
    }

    protected String getRowKey(String resourceId, String tableName, String pk) {
        return resourceId + LOCK_SPLIT + tableName + LOCK_SPLIT + pk;
    }

    @Override
    public void cleanAllLocks() {
    }

    @Override
    public boolean releaseLock(List<RowLock> rowLock) {
        return false;
    }

    @Override
    public boolean releaseLock(String xid, Long branchId) {
        return false;
    }

    @Override
    public boolean releaseLock(String xid) {
        return false;
    }
}

