/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.seata.spring.boot.autoconfigure.StarterConstants;
import org.apache.seata.spring.boot.autoconfigure.properties.server.MetricsProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.ServerProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.ServerRateLimitProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.ServerRecoveryProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.ServerUndoProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.raft.ServerRaftProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.raft.ServerRaftSSLClientProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.raft.ServerRaftSSLProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.raft.ServerRaftSSLServerProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.session.SessionProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.store.DbcpProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.store.DruidProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.store.HikariProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.store.StoreDBProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.store.StoreFileProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.store.StoreProperties;
import org.apache.seata.spring.boot.autoconfigure.properties.server.store.StoreRedisProperties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class SeataServerEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final AtomicBoolean INIT = new AtomicBoolean(false);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        SeataServerEnvironmentPostProcessor.init();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public static void init() {
        if (INIT.compareAndSet(false, true)) {
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server", ServerProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.undo", ServerUndoProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.recovery", ServerRecoveryProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.metrics", MetricsProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.session", StoreProperties.Session.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.lock", StoreProperties.Lock.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.file", StoreFileProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.db", StoreDBProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.db.druid", DruidProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.db.hikari", HikariProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.db.dbcp", DbcpProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.redis", StoreRedisProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.redis.single", StoreRedisProperties.Single.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.redis.sentinel", StoreRedisProperties.Sentinel.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.raft", ServerRaftProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.raft.ssl.server.keystore", ServerRaftSSLServerProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.raft.ssl", ServerRaftSSLProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.raft.ssl.client.keystore", ServerRaftSSLClientProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.session", SessionProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store", StoreProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.ratelimit", ServerRateLimitProperties.class);
        }
    }
}

