/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cluster.HttpIgniteUpdatesChecker;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.jetbrains.annotations.Nullable;

class GridUpdateNotifier {
    private static final String CHARSET = "UTF-8";
    private static final VersionComparator VER_COMPARATOR = new VersionComparator();
    private static final long THROTTLE_PERIOD = 86400000L;
    private static final int WORKER_THREAD_SLEEP_TIME = 5000;
    private static final String DEFAULT_IGNITE_UPDATES_URL = "https://ignite.apache.org/latest";
    private static final String DEFAULT_IGNITE_UPDATES_PARAMS = "?ver=";
    private final String ver;
    private volatile Exception err;
    private volatile String latestVer;
    private volatile String downloadUrl;
    private final String igniteInstanceName;
    private volatile boolean reportOnlyNew;
    private long lastLog = -1L;
    private final AtomicReference<Runnable> cmd = new AtomicReference();
    private final Thread workerThread;
    private final HttpIgniteUpdatesChecker updatesChecker;

    GridUpdateNotifier(String igniteInstanceName, String ver, boolean reportOnlyNew, HttpIgniteUpdatesChecker updatesChecker) throws IgniteCheckedException {
        this.ver = ver;
        this.igniteInstanceName = igniteInstanceName == null ? "null" : igniteInstanceName;
        this.updatesChecker = updatesChecker;
        this.reportOnlyNew = reportOnlyNew;
        this.workerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Runnable cmd0 = GridUpdateNotifier.this.cmd.getAndSet(null);
                        if (cmd0 != null) {
                            cmd0.run();
                            continue;
                        }
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "upd-ver-checker");
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    GridUpdateNotifier(String igniteInstanceName, String ver, boolean reportOnlyNew) throws IgniteCheckedException {
        this(igniteInstanceName, ver, reportOnlyNew, new HttpIgniteUpdatesChecker(DEFAULT_IGNITE_UPDATES_URL, DEFAULT_IGNITE_UPDATES_PARAMS + ver, CHARSET));
    }

    void reportOnlyNew(boolean reportOnlyNew) {
        this.reportOnlyNew = reportOnlyNew;
    }

    String latestVersion() {
        return this.latestVer;
    }

    Exception error() {
        return this.err;
    }

    void checkForNewVersion(IgniteLogger log, boolean first) {
        assert (log != null);
        log = log.getLogger(this.getClass());
        try {
            this.cmd.set(new UpdateChecker(log, first));
        }
        catch (RejectedExecutionException e) {
            U.error(log, "Failed to schedule a thread due to execution rejection (safely ignoring): " + e.getMessage());
        }
    }

    void reportStatus(IgniteLogger log) {
        assert (log != null);
        log = log.getLogger(this.getClass());
        String latestVer = this.latestVer;
        String downloadUrl = this.downloadUrl;
        String string = downloadUrl = downloadUrl != null ? downloadUrl : "ignite.apache.org";
        if (latestVer != null) {
            int cmp = VER_COMPARATOR.compare(latestVer, this.ver);
            if (cmp == 0) {
                if (!this.reportOnlyNew) {
                    this.throttle(log, false, "Your version is up to date.");
                }
            } else if (cmp > 0) {
                this.throttle(log, true, "New version is available at " + downloadUrl + ": " + latestVer);
            }
        } else if (!this.reportOnlyNew) {
            this.throttle(log, false, "Update status is not available.");
        }
    }

    private void throttle(IgniteLogger log, boolean warn, String msg) {
        assert (log != null);
        assert (msg != null);
        long now = U.currentTimeMillis();
        if (now - this.lastLog > 86400000L) {
            if (!warn) {
                U.log(log, msg);
            } else {
                U.quiet(true, msg);
                if (log.isInfoEnabled()) {
                    log.warning(msg);
                }
            }
            this.lastLog = now;
        }
    }

    public void stop() {
        this.workerThread.interrupt();
    }

    private static final class VersionComparator
    implements Comparator<String> {
        private static final String DOT_PATTERN = "\\.";
        private static final String DASH_PATTERN = "-";

        private VersionComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            String[] ver1 = o1.split(DOT_PATTERN, 3);
            String[] ver2 = o2.split(DOT_PATTERN, 3);
            assert (ver1.length == 3);
            assert (ver2.length == 3);
            if (Integer.valueOf(ver1[0]) >= Integer.valueOf(ver2[0]) && Integer.valueOf(ver1[1]) >= Integer.valueOf(ver2[1]) && Integer.valueOf(ver1[2].split(DASH_PATTERN)[0]) >= Integer.valueOf(ver2[2].split(DASH_PATTERN)[0])) {
                return 1;
            }
            return -1;
        }
    }

    private class UpdateChecker
    extends GridWorker {
        private final IgniteLogger log;
        private final boolean first;

        UpdateChecker(IgniteLogger log, boolean first) {
            super(GridUpdateNotifier.this.igniteInstanceName, "grid-version-checker", log);
            this.log = log.getLogger(this.getClass());
            this.first = first;
        }

        @Override
        protected void body() throws InterruptedException {
            block8: {
                try {
                    if (!this.isCancelled()) {
                        try {
                            String[] lines;
                            String updatesRes = GridUpdateNotifier.this.updatesChecker.getUpdates(this.first);
                            for (String line : lines = updatesRes.split("\n")) {
                                if (line.contains("version")) {
                                    GridUpdateNotifier.this.latestVer = this.obtainVersionFrom(line);
                                    continue;
                                }
                                if (!line.contains("downloadUrl")) continue;
                                GridUpdateNotifier.this.downloadUrl = this.obtainDownloadUrlFrom(line);
                            }
                            GridUpdateNotifier.this.err = null;
                        }
                        catch (IOException e) {
                            GridUpdateNotifier.this.err = e;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to connect to Ignite update server. " + e.getMessage());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    GridUpdateNotifier.this.err = e;
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug("Unexpected exception in update checker. " + e.getMessage());
                }
            }
        }

        @Nullable
        private String obtainMeta(String metaName, String line) {
            assert (line.contains(metaName));
            return line.substring(line.indexOf(metaName) + metaName.length()).trim();
        }

        @Nullable
        private String obtainVersionFrom(String line) {
            return this.obtainMeta("version=", line);
        }

        @Nullable
        private String obtainDownloadUrlFrom(String line) {
            return this.obtainMeta("downloadUrl=", line);
        }
    }
}

