/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.PrintStream;
import me.tongfei.progressbar.ConsoleProgressBarConsumer;
import me.tongfei.progressbar.StringDisplayUtils;
import me.tongfei.progressbar.TerminalUtils;

public class InteractiveConsoleProgressBarConsumer
extends ConsoleProgressBarConsumer {
    private boolean initialized = false;
    private int position = 1;

    public InteractiveConsoleProgressBarConsumer(PrintStream out) {
        super(out);
    }

    public InteractiveConsoleProgressBarConsumer(PrintStream out, int predefinedWidth) {
        super(out, predefinedWidth);
    }

    @Override
    public void accept(String str) {
        String s = StringDisplayUtils.trimDisplayLength(str, this.getMaxRenderedLength());
        if (!this.initialized) {
            TerminalUtils.filterActiveConsumers(InteractiveConsoleProgressBarConsumer.class).forEach(c -> ++c.position);
            TerminalUtils.activeConsumers.add(this);
            this.out.println('\r' + s);
            this.initialized = true;
        } else {
            this.out.print(TerminalUtils.moveCursorUp(this.position) + s + TerminalUtils.moveCursorDown(this.position));
        }
    }

    @Override
    public void close() {
        this.out.flush();
        TerminalUtils.activeConsumers.remove(this);
    }
}

