/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantPropagateProcCtx
implements NodeProcessorCtx {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantPropagateProcCtx.class);
    private final Map<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>> opToConstantExprs;
    private final Set<Operator<? extends Serializable>> opToDelete;
    private ConstantPropagateOption constantPropagateOption = ConstantPropagateOption.FULL;

    public ConstantPropagateProcCtx() {
        this(ConstantPropagateOption.FULL);
    }

    public ConstantPropagateProcCtx(ConstantPropagateOption option) {
        this.opToConstantExprs = new HashMap<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>>();
        this.opToDelete = new HashSet<Operator<? extends Serializable>>();
        this.constantPropagateOption = option;
    }

    public Map<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>> getOpToConstantExprs() {
        return this.opToConstantExprs;
    }

    public Map<ColumnInfo, ExprNodeDesc> getPropagatedConstants(Operator<? extends Serializable> op) {
        HashMap<ColumnInfo, ExprNodeDesc> constants = new HashMap<ColumnInfo, ExprNodeDesc>();
        if (op.getSchema() == null) {
            return constants;
        }
        RowSchema rs = op.getSchema();
        LOG.debug("Getting constants of op:" + String.valueOf(op) + " with rs:" + String.valueOf(rs));
        if (op.getParentOperators() == null) {
            return constants;
        }
        ArrayList parentsToConstant = new ArrayList();
        boolean areAllParentsContainConstant = true;
        boolean noParentsContainConstant = true;
        for (Operator<OperatorDesc> parent : op.getParentOperators()) {
            Map<ColumnInfo, ExprNodeDesc> constMap = this.opToConstantExprs.get(parent);
            if (constMap == null) {
                LOG.debug("Constant of Op " + parent.getOperatorId() + " is not found");
                areAllParentsContainConstant = false;
                continue;
            }
            noParentsContainConstant = false;
            HashMap map = new HashMap();
            for (Map.Entry<ColumnInfo, ExprNodeDesc> entry : constMap.entrySet()) {
                map.put(parent.getSchema().getPosition(entry.getKey().getInternalName()), entry.getValue());
            }
            parentsToConstant.add(map);
            LOG.debug("Constant of Op " + parent.getOperatorId() + " " + String.valueOf(constMap));
        }
        if (noParentsContainConstant) {
            return constants;
        }
        List<ColumnInfo> signature = op.getSchema().getSignature();
        if (op instanceof LimitOperator || op instanceof FilterOperator) {
            if (op.getParentOperators().size() == 1) {
                Map parentToConstant = (Map)parentsToConstant.get(0);
                for (int index = 0; index < signature.size(); ++index) {
                    if (!parentToConstant.containsKey(index)) continue;
                    constants.put(signature.get(index), (ExprNodeDesc)parentToConstant.get(index));
                }
            }
        } else if (op instanceof UnionOperator && areAllParentsContainConstant) {
            for (int index = 0; index < signature.size(); ++index) {
                ExprNodeDesc constant = null;
                for (Map map : parentsToConstant) {
                    if (!map.containsKey(index)) {
                        constant = null;
                        break;
                    }
                    if (constant == null) {
                        constant = (ExprNodeDesc)map.get(index);
                        continue;
                    }
                    ExprNodeDesc nextConstant = (ExprNodeDesc)map.get(index);
                    if (nextConstant.isSame(constant)) continue;
                    constant = null;
                    break;
                }
                if (constant == null) continue;
                constants.put(signature.get(index), constant);
            }
        } else if (op instanceof JoinOperator) {
            JoinOperator joinOp = (JoinOperator)op;
            for (Map.Entry<Byte, List<ExprNodeDesc>> e : ((JoinDesc)joinOp.getConf()).getExprs().entrySet()) {
                byte by = e.getKey();
                Operator<OperatorDesc> parent = op.getParentOperators().get(by);
                List<ExprNodeDesc> exprs = e.getValue();
                if (exprs == null) continue;
                for (ExprNodeDesc expr : exprs) {
                    if (!(expr instanceof ExprNodeColumnDesc)) continue;
                    String parentColName = ((ExprNodeColumnDesc)expr).getColumn();
                    int parentPos = parent.getSchema().getPosition(parentColName);
                    if (!((Map)parentsToConstant.get(by)).containsKey(parentPos) || op.getColumnExprMap() == null || op.getColumnExprMap().entrySet() == null) continue;
                    for (Map.Entry<String, ExprNodeDesc> entry : op.getColumnExprMap().entrySet()) {
                        if (!entry.getValue().isSame(expr)) continue;
                        constants.put(signature.get(op.getSchema().getPosition(entry.getKey())), (ExprNodeDesc)((Map)parentsToConstant.get(by)).get(parentPos));
                    }
                }
            }
        } else if (op.getParentOperators().size() == 1) {
            Operator<OperatorDesc> parent;
            parent = op.getParentOperators().get(0);
            if (op.getColumnExprMap() != null && op.getColumnExprMap().entrySet() != null) {
                for (Map.Entry<String, ExprNodeDesc> entry : op.getColumnExprMap().entrySet()) {
                    ExprNodeDesc exprNodeDesc;
                    if (op.getSchema().getPosition(entry.getKey()) == -1 || !((exprNodeDesc = entry.getValue()) instanceof ExprNodeColumnDesc)) continue;
                    String parentColName = ((ExprNodeColumnDesc)exprNodeDesc).getColumn();
                    int parentPos = parent.getSchema().getPosition(parentColName);
                    if (!((Map)parentsToConstant.get(0)).containsKey(parentPos)) continue;
                    constants.put(signature.get(op.getSchema().getPosition(entry.getKey())), (ExprNodeDesc)((Map)parentsToConstant.get(0)).get(parentPos));
                }
            }
        }
        LOG.debug("Offering constants " + String.valueOf(constants.keySet()) + " to operator " + op.toString());
        return constants;
    }

    public void addOpToDelete(Operator<? extends Serializable> op) {
        this.opToDelete.add(op);
    }

    public Set<Operator<? extends Serializable>> getOpToDelete() {
        return this.opToDelete;
    }

    public ConstantPropagateOption getConstantPropagateOption() {
        return this.constantPropagateOption;
    }

    public void setConstantPropagateOption(ConstantPropagateOption constantPropagateOption) {
        this.constantPropagateOption = constantPropagateOption;
    }

    public static enum ConstantPropagateOption {
        FULL,
        SHORTCUT;

    }
}

