/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncDecimalToLong;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public class CastDecimalToLong
extends FuncDecimalToLong {
    private static final long serialVersionUID = 1L;

    public CastDecimalToLong() {
    }

    public CastDecimalToLong(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    @Override
    protected void func(LongColumnVector outV, DecimalColumnVector inV, int i) {
        HiveDecimalWritable decWritable = inV.vector[i];
        if (!(switch (this.integerPrimitiveCategory) {
            case PrimitiveObjectInspector.PrimitiveCategory.BYTE -> decWritable.isByte();
            case PrimitiveObjectInspector.PrimitiveCategory.SHORT -> decWritable.isShort();
            case PrimitiveObjectInspector.PrimitiveCategory.INT -> decWritable.isInt();
            case PrimitiveObjectInspector.PrimitiveCategory.LONG -> decWritable.isLong();
            default -> throw new RuntimeException("Unexpected integer primitive category " + String.valueOf(this.integerPrimitiveCategory));
        })) {
            outV.isNull[i] = true;
            outV.noNulls = false;
            return;
        }
        outV.isNull[i] = false;
        switch (this.integerPrimitiveCategory) {
            case BYTE: {
                outV.vector[i] = decWritable.byteValue();
                break;
            }
            case SHORT: {
                outV.vector[i] = decWritable.shortValue();
                break;
            }
            case INT: {
                outV.vector[i] = decWritable.intValue();
                break;
            }
            case LONG: {
                outV.vector[i] = decWritable.longValue();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected integer primitive category " + String.valueOf(this.integerPrimitiveCategory));
            }
        }
    }
}

