/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.service.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDirCleaner
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDirCleaner.class);
    private List<String> localDirs;
    private long cleanupIntervalSec;
    private long fileModifyTimeThresholdSec;
    ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public LocalDirCleaner(String[] localDirs, Configuration conf) {
        super("LocalDirCleaner");
        this.localDirs = Arrays.asList(localDirs);
        this.cleanupIntervalSec = this.getInterval(conf);
        this.fileModifyTimeThresholdSec = this.getFileModifyTimeThreshold(conf);
        LOG.info("Initialized local dir cleaner: interval: {}s, threshold: {}s", (Object)this.cleanupIntervalSec, (Object)this.fileModifyTimeThresholdSec);
    }

    public void serviceStart() throws IOException {
        this.scheduler.scheduleAtFixedRate(this::cleanup, 0L, this.cleanupIntervalSec, TimeUnit.SECONDS);
    }

    public void serviceStop() throws IOException {
        this.scheduler.shutdownNow();
    }

    private long getFileModifyTimeThreshold(Configuration conf) {
        return HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LOCAL_DIR_CLEANER_FILE_MODIFY_TIME_THRESHOLD, (TimeUnit)TimeUnit.SECONDS);
    }

    private long getInterval(Configuration conf) {
        return HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LOCAL_DIR_CLEANER_CLEANUP_INTERVAL, (TimeUnit)TimeUnit.SECONDS);
    }

    private void cleanup() {
        Instant deleteBefore = Instant.now().minus(this.fileModifyTimeThresholdSec, ChronoUnit.SECONDS);
        this.localDirs.forEach(localDir -> this.cleanupPath(deleteBefore, Paths.get(localDir, new String[0])));
    }

    private void cleanupPath(Instant deleteBefore, Path pathLocalDir) {
        LOG.info("Cleaning up files older than {} from {}", (Object)deleteBefore, (Object)pathLocalDir);
        try (Stream<Path> files = Files.walk(pathLocalDir, new FileVisitOption[0]);){
            files.filter(f -> {
                try {
                    FileTime modified = Files.getLastModifiedTime(f, new LinkOption[0]);
                    LOG.debug("Checking: {}, modified: {}", f, (Object)modified);
                    return Files.isRegularFile(f, new LinkOption[0]) && modified.toInstant().isBefore(deleteBefore);
                }
                catch (IOException ex) {
                    LOG.warn("IOException caught while checking file for deletion", (Throwable)ex);
                    return false;
                }
            }).forEach(f -> {
                try {
                    LOG.info("Delete old local file: {}", f);
                    Files.delete(f);
                }
                catch (IOException ex) {
                    LOG.warn("Failed to delete file", (Throwable)ex);
                }
            });
        }
        catch (IOException e) {
            LOG.warn("IOException caught while walking over local files", (Throwable)e);
        }
    }
}

