/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.service.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapLoadGeneratorService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(LlapLoadGeneratorService.class);
    private long interval;
    private float threshold;
    private String[] victimsHostName;
    @VisibleForTesting
    Thread[] threads;

    public LlapLoadGeneratorService() {
        super("LlapLoadGeneratorService");
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.threshold = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_UTILIZATION);
        if (this.threshold < 0.0f || (double)this.threshold > 1.0) {
            throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_TEST_LOAD_UTILIZATION.varname + " should be between 0.0 and 1.0. The configuration specified [" + this.threshold + "]");
        }
        this.victimsHostName = HiveConf.getTrimmedStringsVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_HOSTNAMES);
        this.interval = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_LOAD_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        LOG.info("LlapLoadGeneratorService init with {} {} {}", new Object[]{this.interval, Float.valueOf(this.threshold), this.victimsHostName});
    }

    protected void serviceStart() throws UnknownHostException {
        String localHostName = InetAddress.getLocalHost().getHostName();
        LOG.debug("Local hostname is: {}", (Object)localHostName);
        for (String hostName : this.victimsHostName) {
            if (!hostName.equalsIgnoreCase(localHostName)) continue;
            LOG.debug("Starting load generator process on: {}", (Object)localHostName);
            this.threads = new Thread[Runtime.getRuntime().availableProcessors()];
            final Random random = new Random();
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (!Thread.interrupted()) {
                            if (random.nextFloat() <= LlapLoadGeneratorService.this.threshold) {
                                long startTime = System.currentTimeMillis();
                                while (System.currentTimeMillis() - startTime < LlapLoadGeneratorService.this.interval && !Thread.currentThread().isInterrupted()) {
                                }
                                continue;
                            }
                            try {
                                Thread.sleep(LlapLoadGeneratorService.this.interval);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                });
                this.threads[i].start();
            }
        }
    }

    protected void serviceStop() throws Exception {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].interrupt();
        }
    }
}

