/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.io.BaseEncoding;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.buffer.ByteBuf;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.CharsetUtil;
import org.apache.hive.kudu.org.apache.kudu.util.DecimalUtil;
import org.apache.hive.kudu.org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Bytes {
    private static final BigInteger TWO_COMPL_REF = BigInteger.ONE.shiftLeft(64);
    private static final BigInteger BIGINT32_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger BIGINT32_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger BIGINT64_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger BIGINT64_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final MemCmp MEMCMP = new MemCmp();

    private Bytes() {
    }

    public static boolean getBoolean(byte[] b) {
        byte v = Bytes.getByte(b, 0);
        return v == 1;
    }

    public static boolean getBoolean(byte[] b, int offset) {
        byte v = Bytes.getByte(b, offset);
        return v == 1;
    }

    public static byte getByte(byte[] b) {
        return Bytes.getByte(b, 0);
    }

    public static byte getByte(byte[] b, int offset) {
        return b[offset];
    }

    public static short getUnsignedByte(byte[] b) {
        return Bytes.getUnsignedByte(b, 0);
    }

    public static short getUnsignedByte(byte[] b, int offset) {
        return (short)(b[offset] & 0xFF);
    }

    public static void setUnsignedByte(byte[] b, short n) {
        Bytes.setUnsignedByte(b, n, 0);
    }

    public static void setUnsignedByte(byte[] b, short n, int offset) {
        b[offset] = (byte)n;
    }

    public static byte[] fromUnsignedByte(short n) {
        byte[] b = new byte[1];
        Bytes.setUnsignedByte(b, n);
        return b;
    }

    public static short getShort(byte[] b) {
        return Bytes.getShort(b, 0);
    }

    public static short getShort(byte[] b, int offset) {
        return (short)(b[offset] & 0xFF | b[offset + 1] << 8);
    }

    public static int getUnsignedShort(byte[] b) {
        return Bytes.getUnsignedShort(b, 0);
    }

    public static int getUnsignedShort(byte[] b, int offset) {
        return Bytes.getShort(b, offset) & 0xFFFF;
    }

    public static void setShort(byte[] b, short n) {
        Bytes.setShort(b, n, 0);
    }

    public static void setShort(byte[] b, short n, int offset) {
        b[offset + 0] = (byte)(n >>> 0);
        b[offset + 1] = (byte)(n >>> 8);
    }

    public static void setUnsignedShort(byte[] b, int n) {
        Bytes.setUnsignedShort(b, n, 0);
    }

    public static void setUnsignedShort(byte[] b, int n, int offset) {
        b[offset + 0] = (byte)(n >>> 0);
        b[offset + 1] = (byte)(n >>> 8);
    }

    public static byte[] fromShort(short n) {
        byte[] b = new byte[2];
        Bytes.setShort(b, n);
        return b;
    }

    public static byte[] fromUnsignedShort(int n) {
        byte[] b = new byte[2];
        Bytes.setUnsignedShort(b, n);
        return b;
    }

    public static int getInt(byte[] b) {
        return Bytes.getInt(b, 0);
    }

    public static int getInt(byte[] b, int offset) {
        return (b[offset + 0] & 0xFF) << 0 | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | (b[offset + 3] & 0xFF) << 24;
    }

    public static long getUnsignedInt(byte[] b) {
        return Bytes.getUnsignedInt(b, 0);
    }

    public static long getUnsignedInt(byte[] b, int offset) {
        return (long)Bytes.getInt(b, offset) & 0xFFFFFFFFL;
    }

    public static void setInt(byte[] b, int n) {
        Bytes.setInt(b, n, 0);
    }

    public static void setInt(byte[] b, int n, int offset) {
        b[offset + 0] = (byte)(n >>> 0);
        b[offset + 1] = (byte)(n >>> 8);
        b[offset + 2] = (byte)(n >>> 16);
        b[offset + 3] = (byte)(n >>> 24);
    }

    public static void setUnsignedInt(byte[] b, long n) {
        Bytes.setUnsignedInt(b, n, 0);
    }

    public static void setUnsignedInt(byte[] b, long n, int offset) {
        b[offset + 0] = (byte)(n >>> 0);
        b[offset + 1] = (byte)(n >>> 8);
        b[offset + 2] = (byte)(n >>> 16);
        b[offset + 3] = (byte)(n >>> 24);
    }

    public static void putVarInt32(ByteBuffer b, int v) {
        int bee = 128;
        if (v < 128) {
            b.put((byte)v);
        } else if (v < 16384) {
            b.put((byte)(v | bee));
            b.put((byte)(v >> 7 | bee));
        } else if (v < 0x200000) {
            b.put((byte)(v | bee));
            b.put((byte)(v >> 7 | bee));
            b.put((byte)(v >> 14));
        } else if (v < 0x10000000) {
            b.put((byte)(v | bee));
            b.put((byte)(v >> 7 | bee));
            b.put((byte)(v >> 14 | bee));
            b.put((byte)(v >> 21));
        } else {
            b.put((byte)(v | bee));
            b.put((byte)(v >> 7 | bee));
            b.put((byte)(v >> 14 | bee));
            b.put((byte)(v >> 21 | bee));
            b.put((byte)(v >> 28));
        }
    }

    static int readVarInt32(ByteBuf buf) {
        int result = buf.readByte();
        if (result >= 0) {
            return result;
        }
        result &= 0x7F;
        if ((result |= buf.readByte() << 7) >= 0) {
            return result;
        }
        result &= 0x3FFF;
        if ((result |= buf.readByte() << 14) >= 0) {
            return result;
        }
        result &= 0x1FFFFF;
        if ((result |= buf.readByte() << 21) >= 0) {
            return result;
        }
        result &= 0xFFFFFFF;
        byte b = buf.readByte();
        result |= b << 28;
        if (b >= 0) {
            return result;
        }
        throw new IllegalArgumentException("Not a 32 bit varint: " + result + " (5th byte: " + b + ")");
    }

    public static byte[] fromBoolean(boolean n) {
        byte[] b = new byte[]{(byte)(n ? 1 : 0)};
        return b;
    }

    public static byte[] fromInt(int n) {
        byte[] b = new byte[4];
        Bytes.setInt(b, n);
        return b;
    }

    public static byte[] fromUnsignedInt(long n) {
        byte[] b = new byte[4];
        Bytes.setUnsignedInt(b, n);
        return b;
    }

    public static BigInteger getUnsignedLong(byte[] b) {
        return Bytes.getUnsignedLong(b, 0);
    }

    public static BigInteger getUnsignedLong(byte[] b, int offset) {
        long l = Bytes.getLong(b, offset);
        BigInteger bi = BigInteger.valueOf(l);
        if (bi.compareTo(BigInteger.ZERO) < 0) {
            bi = bi.add(TWO_COMPL_REF);
        }
        return bi;
    }

    public static long getLong(byte[] b) {
        return Bytes.getLong(b, 0);
    }

    public static long getLong(byte[] b, int offset) {
        return ((long)b[offset + 0] & 0xFFL) << 0 | ((long)b[offset + 1] & 0xFFL) << 8 | ((long)b[offset + 2] & 0xFFL) << 16 | ((long)b[offset + 3] & 0xFFL) << 24 | ((long)b[offset + 4] & 0xFFL) << 32 | ((long)b[offset + 5] & 0xFFL) << 40 | ((long)b[offset + 6] & 0xFFL) << 48 | ((long)b[offset + 7] & 0xFFL) << 56;
    }

    public static void setLong(byte[] b, long n) {
        Bytes.setLong(b, n, 0);
    }

    public static void setLong(byte[] b, long n, int offset) {
        b[offset + 0] = (byte)(n >>> 0);
        b[offset + 1] = (byte)(n >>> 8);
        b[offset + 2] = (byte)(n >>> 16);
        b[offset + 3] = (byte)(n >>> 24);
        b[offset + 4] = (byte)(n >>> 32);
        b[offset + 5] = (byte)(n >>> 40);
        b[offset + 6] = (byte)(n >>> 48);
        b[offset + 7] = (byte)(n >>> 56);
    }

    public static void setUnsignedLong(byte[] b, BigInteger n) {
        Bytes.setUnsignedLong(b, n, 0);
    }

    public static void setUnsignedLong(byte[] b, BigInteger n, int offset) {
        Bytes.setLong(b, n.longValue(), offset);
    }

    public static byte[] fromLong(long n) {
        byte[] b = new byte[8];
        Bytes.setLong(b, n);
        return b;
    }

    public static byte[] fromUnsignedLong(BigInteger n) {
        byte[] b = new byte[8];
        Bytes.setUnsignedLong(b, n);
        return b;
    }

    public static BigInteger getBigInteger(byte[] b) {
        return Bytes.getBigInteger(b, 0);
    }

    public static BigInteger getBigInteger(byte[] b, int offset) {
        byte[] bytes = Arrays.copyOfRange(b, offset, offset + 16);
        Bytes.reverseBytes(bytes);
        return new BigInteger(bytes);
    }

    public static void setBigInteger(byte[] b, BigInteger n) {
        Bytes.setBigInteger(b, n, 0);
    }

    public static void setBigInteger(byte[] b, BigInteger n, int offset) {
        byte[] bytes = n.toByteArray();
        if (bytes.length > 16) {
            throw new IllegalArgumentException("Value is larger than the maximum 16 bytes: " + n);
        }
        Bytes.reverseBytes(bytes);
        System.arraycopy(bytes, 0, b, offset, bytes.length);
        if (n.compareTo(BigInteger.ZERO) < 0) {
            Arrays.fill(b, offset + bytes.length, offset + 16, (byte)-1);
        }
    }

    public static byte[] fromBigInteger(BigInteger n) {
        byte[] b = new byte[16];
        Bytes.setBigInteger(b, n);
        return b;
    }

    private static void reverseBytes(byte[] b) {
        for (int i = 0; i < b.length / 2; ++i) {
            byte temp = b[i];
            b[i] = b[b.length - i - 1];
            b[b.length - i - 1] = temp;
        }
    }

    public static float getFloat(byte[] b) {
        return Bytes.getFloat(b, 0);
    }

    public static float getFloat(byte[] b, int offset) {
        return Float.intBitsToFloat(Bytes.getInt(b, offset));
    }

    public static void setFloat(byte[] b, float n) {
        Bytes.setFloat(b, n, 0);
    }

    public static void setFloat(byte[] b, float n, int offset) {
        Bytes.setInt(b, Float.floatToIntBits(n), offset);
    }

    public static byte[] fromFloat(float n) {
        byte[] b = new byte[4];
        Bytes.setFloat(b, n);
        return b;
    }

    public static double getDouble(byte[] b) {
        return Bytes.getDouble(b, 0);
    }

    public static double getDouble(byte[] b, int offset) {
        return Double.longBitsToDouble(Bytes.getLong(b, offset));
    }

    public static void setDouble(byte[] b, double n) {
        Bytes.setDouble(b, n, 0);
    }

    public static void setDouble(byte[] b, double n, int offset) {
        Bytes.setLong(b, Double.doubleToLongBits(n), offset);
    }

    public static byte[] fromDouble(double n) {
        byte[] b = new byte[8];
        Bytes.setDouble(b, n);
        return b;
    }

    public static BigDecimal getDecimal(byte[] b, int precision, int scale) {
        return Bytes.getDecimal(b, 0, precision, scale);
    }

    public static BigDecimal getDecimal(byte[] b, int offset, int precision, int scale) {
        int size = DecimalUtil.precisionToSize(precision);
        switch (size) {
            case 4: {
                int intVal = Bytes.getInt(b, offset);
                return BigDecimal.valueOf(intVal, scale);
            }
            case 8: {
                long longVal = Bytes.getLong(b, offset);
                return BigDecimal.valueOf(longVal, scale);
            }
            case 16: {
                BigInteger int128Val = Bytes.getBigInteger(b, offset);
                return new BigDecimal(int128Val, scale);
            }
        }
        throw new IllegalArgumentException("Unsupported decimal type size: " + size);
    }

    public static void setBigDecimal(byte[] b, BigDecimal n, int precision) {
        Bytes.setBigDecimal(b, n, precision, 0);
    }

    public static void setBigDecimal(byte[] b, BigDecimal n, int precision, int offset) {
        int size = DecimalUtil.precisionToSize(precision);
        BigInteger bigInt = n.unscaledValue();
        switch (size) {
            case 4: {
                if (bigInt.compareTo(BIGINT32_MIN) >= 0 && bigInt.compareTo(BIGINT32_MAX) <= 0) {
                    Bytes.setInt(b, bigInt.intValue(), offset);
                    break;
                }
                throw new ArithmeticException("BigInteger out of int range");
            }
            case 8: {
                if (bigInt.compareTo(BIGINT64_MIN) >= 0 && bigInt.compareTo(BIGINT64_MAX) <= 0) {
                    Bytes.setLong(b, bigInt.longValue(), offset);
                    break;
                }
                throw new ArithmeticException("BigInteger out of int range");
            }
            case 16: {
                Bytes.setBigInteger(b, bigInt, offset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported decimal type size: " + size);
            }
        }
    }

    public static byte[] fromBigDecimal(BigDecimal n, int precision) {
        int size = DecimalUtil.precisionToSize(precision);
        switch (size) {
            case 4: {
                return Bytes.fromInt(n.unscaledValue().intValue());
            }
            case 8: {
                return Bytes.fromLong(n.unscaledValue().longValue());
            }
            case 16: {
                return Bytes.fromBigInteger(n.unscaledValue());
            }
        }
        throw new IllegalArgumentException("Unsupported decimal type size: " + size);
    }

    public static byte[] UTF8(String s2) {
        return s2.getBytes(CharsetUtil.UTF_8);
    }

    public static byte[] ISO88591(String s2) {
        return s2.getBytes(CharsetUtil.ISO_8859_1);
    }

    public static void pretty(StringBuilder outbuf, byte[] array) {
        if (array == null) {
            outbuf.append("null");
            return;
        }
        int ascii = 0;
        int start_length = outbuf.length();
        int n = array.length;
        outbuf.ensureCapacity(start_length + 1 + n + 1);
        outbuf.append('\"');
        for (int i = 0; i < n; ++i) {
            byte b = array[i];
            if (32 <= b && b <= 126) {
                ++ascii;
                outbuf.append((char)b);
                continue;
            }
            if (b == 10) {
                outbuf.append('\\').append('n');
                continue;
            }
            if (b == 9) {
                outbuf.append('\\').append('t');
                continue;
            }
            outbuf.append("\\x").append(HEX[b >>> 4 & 0xF]).append(HEX[b & 0xF]);
        }
        if (ascii < n / 2) {
            outbuf.setLength(start_length);
            outbuf.append(Arrays.toString(array));
        } else {
            outbuf.append('\"');
        }
    }

    public static void pretty(StringBuilder outbuf, byte[][] arrays) {
        if (arrays == null) {
            outbuf.append("null");
            return;
        }
        int size = 2;
        for (int i = 0; i < arrays.length; ++i) {
            size += 4 + arrays[i].length;
        }
        outbuf.ensureCapacity(outbuf.length() + size);
        outbuf.append('[');
        for (int i = 0; i < arrays.length; ++i) {
            Bytes.pretty(outbuf, arrays[i]);
            outbuf.append(", ");
        }
        outbuf.setLength(outbuf.length() - 2);
        outbuf.append(']');
    }

    public static String pretty(byte[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder(1 + array.length + 1);
        Bytes.pretty(buf, array);
        return buf.toString();
    }

    public static String pretty(ByteBuf buf) {
        if (buf == null) {
            return "null";
        }
        byte[] array = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), array);
        return Bytes.pretty(array);
    }

    public static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 + bytes.length * 2);
        sb.append('0');
        sb.append('x');
        sb.append(BaseEncoding.base16().encode(bytes));
        return sb.toString();
    }

    public static int memcmp(byte[] a, byte[] b) {
        int length = Math.min(a.length, b.length);
        if (a == b) {
            return 0;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return (a[i] & 0xFF) - (b[i] & 0xFF);
        }
        return a.length - b.length;
    }

    public static int memcmp(byte[] a, byte[] b, int offset, int length) {
        if (a == b && a != null) {
            return 0;
        }
        length += offset;
        for (int i = offset; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return (a[i] & 0xFF) - (b[i] & 0xFF);
        }
        return 0;
    }

    public static byte[] deDup(byte[] old, byte[] neww) {
        return Bytes.memcmp(old, neww) == 0 ? old : neww;
    }

    public static boolean equals(byte[] a, byte[] b) {
        return Bytes.memcmp(a, b) == 0;
    }

    public static int memcmpMaybeNull(byte[] a, byte[] b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return Bytes.memcmp(a, b);
    }

    public static int getBitSetSize(int items) {
        return (items + 7) / 8;
    }

    public static byte[] fromBitSet(BitSet bits, int colCount) {
        byte[] bytes = new byte[Bytes.getBitSetSize(colCount)];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | (byte)(1 << i % 8));
        }
        return bytes;
    }

    public static BitSet toBitSet(byte[] b, int offset, int colCount) {
        BitSet bs = new BitSet(colCount);
        for (int i = 0; i < colCount; ++i) {
            if ((b[offset + i / 8] >> i % 8 & 1) != 1) continue;
            bs.set(i);
        }
        return bs;
    }

    public static byte xorLeftMostBit(byte value) {
        value = (byte)(value ^ 0xFFFFFF80);
        return value;
    }

    public static byte[] fromString(String data) {
        return Bytes.UTF8(data);
    }

    public static String getString(byte[] b) {
        return Bytes.getString(b, 0, b.length);
    }

    public static String getString(Slice slice) {
        return slice.toString(CharsetUtil.UTF_8);
    }

    public static String getString(byte[] b, int offset, int len) {
        if (len == 0) {
            return "";
        }
        return new String(b, offset, len, CharsetUtil.UTF_8);
    }

    public static void writeByteArray(DataOutput dataOutput, byte[] b) throws IOException {
        dataOutput.writeInt(b.length);
        dataOutput.write(b);
    }

    public static byte[] readByteArray(DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        byte[] data = new byte[len];
        dataInput.readFully(data);
        return data;
    }

    private static final class MemCmp
    implements Comparator<byte[]>,
    Serializable {
        private static final long serialVersionUID = 914981342853419168L;

        private MemCmp() {
        }

        @Override
        public int compare(byte[] a, byte[] b) {
            return Bytes.memcmp(a, b);
        }
    }
}

