/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionState;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.InsertCompactionRequestCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GenerateCompactionQueueIdFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GetValidWriteIdsFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CompactFunction
implements TransactionalFunction<CompactionResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(CompactFunction.class);
    private final CompactionRequest rqst;
    private final long openTxnTimeOutMillis;
    private final TxnStore.MutexAPI mutexAPI;

    public CompactFunction(CompactionRequest rqst, long openTxnTimeOutMillis, TxnStore.MutexAPI mutexAPI) {
        this.rqst = rqst;
        this.openTxnTimeOutMillis = openTxnTimeOutMillis;
        this.mutexAPI = mutexAPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionResponse execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.mutexAPI.acquireLock(TxnStore.MUTEX_KEY.CompactionScheduler.name());
            GetValidWriteIdsRequest request = new GetValidWriteIdsRequest(Collections.singletonList(TxnUtils.getFullTableName(this.rqst.getDbname(), this.rqst.getTablename())));
            ValidCompactorWriteIdList tblValidWriteIds = TxnUtils.createValidCompactWriteIdList((TableValidWriteIds)new GetValidWriteIdsFunction(request, this.openTxnTimeOutMillis).execute(jdbcResource).getTblValidWriteIds().get(0));
            if (LOG.isDebugEnabled()) {
                LOG.debug("ValidCompactWriteIdList: {}", (Object)tblValidWriteIds.writeToString());
            }
            NamedParameterJdbcTemplate npJdbcTemplate = jdbcResource.getJdbcTemplate();
            Pair existing = (Pair)npJdbcTemplate.query("SELECT \"CQ_ID\", \"CQ_STATE\" FROM \"COMPACTION_QUEUE\" WHERE (\"CQ_STATE\" IN(:states) OR (\"CQ_STATE\" = :readyForCleaningState AND \"CQ_HIGHEST_WRITE_ID\" = :highestWriteId)) AND \"CQ_DATABASE\"= :dbName AND \"CQ_TABLE\"= :tableName AND ((:partition is NULL AND \"CQ_PARTITION\" IS NULL) OR \"CQ_PARTITION\" = :partition)", (SqlParameterSource)new MapSqlParameterSource().addValue("states", Arrays.asList(Character.toString('i'), Character.toString('w'))).addValue("readyForCleaningState", (Object)Character.valueOf('r'), 12).addValue("highestWriteId", (Object)tblValidWriteIds.getHighWatermark()).addValue("dbName", (Object)this.rqst.getDbname()).addValue("tableName", (Object)this.rqst.getTablename()).addValue("partition", (Object)this.rqst.getPartitionname(), 12), rs -> {
                if (rs.next()) {
                    return new ImmutablePair((Object)rs.getLong("CQ_ID"), (Object)rs.getString("CQ_STATE"));
                }
                return null;
            });
            if (existing != null) {
                String state = CompactionState.fromSqlConst((String)existing.getValue()).toString();
                LOG.info("Ignoring request to compact {}/{}/{} since it is already {} with id={}", new Object[]{this.rqst.getDbname(), this.rqst.getTablename(), this.rqst.getPartitionname(), state, existing.getKey()});
                CompactionResponse resp = new CompactionResponse(-1L, "refused", false);
                resp.setErrormessage("Compaction is already scheduled with state='" + state + "' and id=" + String.valueOf(existing.getKey()));
                CompactionResponse compactionResponse = resp;
                return compactionResponse;
            }
            long id = new GenerateCompactionQueueIdFunction().execute(jdbcResource);
            jdbcResource.execute(new InsertCompactionRequestCommand(id, CompactionState.INITIATED, this.rqst));
            CompactionResponse compactionResponse = new CompactionResponse(id, "initiated", true);
            return compactionResponse;
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
    }
}

