/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Pair;

public class SortedMerge<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final Comparator<T> comparator;
    private final List<CloseableIterable<T>> iterables;

    public static <C extends Comparable<C>> CloseableIterable<C> of(Iterable<C> left, Iterable<C> right) {
        return SortedMerge.of(Arrays.asList(left, right));
    }

    public static <C extends Comparable<C>> CloseableIterable<C> of(List<Iterable<C>> iterables) {
        List closeableIterables = Lists.transform(iterables, CloseableIterable::of);
        return new SortedMerge(Comparator.naturalOrder(), closeableIterables);
    }

    public SortedMerge(Comparator<T> comparator, List<CloseableIterable<T>> iterables) {
        this.comparator = comparator;
        this.iterables = iterables;
    }

    @Override
    public CloseableIterator<T> iterator() {
        List iterators = this.iterables.stream().map(CloseableIterable::iterator).filter(Iterator::hasNext).collect(Collectors.toList());
        if (iterators.size() == 1) {
            this.addCloseable((Closeable)iterators.get(0));
            return iterators.get(0);
        }
        MergeIterator merge = new MergeIterator(iterators);
        this.addCloseable(merge);
        return merge;
    }

    private class MergeIterator
    implements CloseableIterator<T> {
        private final PriorityQueue<Pair<T, Iterator<T>>> heap;

        private MergeIterator(Iterable<CloseableIterator<T>> iterators) {
            this.heap = new PriorityQueue<Pair>(Comparator.comparing(Pair::first, SortedMerge.this.comparator));
            iterators.forEach(this::addNext);
        }

        @Override
        public boolean hasNext() {
            return !this.heap.isEmpty();
        }

        @Override
        public T next() {
            if (this.heap.isEmpty()) {
                throw new NoSuchElementException();
            }
            Pair pair = this.heap.poll();
            this.addNext(pair.second());
            return pair.first();
        }

        private void addNext(Iterator<T> iter) {
            if (iter.hasNext()) {
                this.heap.add(Pair.of(iter.next(), iter));
            } else {
                this.close(iter);
            }
        }

        @Override
        public void close() throws IOException {
            while (!this.heap.isEmpty()) {
                Pair pair = this.heap.poll();
                this.close(pair.second());
            }
        }

        private void close(Iterator<?> iter) {
            if (iter instanceof Closeable) {
                try {
                    ((Closeable)((Object)iter)).close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

