/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.servlet.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.boot.actuate.health.AdditionalHealthEndpointPath;
import org.springframework.boot.actuate.health.HealthEndpointGroup;

public class AdditionalHealthEndpointPathsWebMvcHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private final ExposableWebEndpoint healthEndpoint;
    private final Set<HealthEndpointGroup> groups;

    public AdditionalHealthEndpointPathsWebMvcHandlerMapping(ExposableWebEndpoint healthEndpoint, Set<HealthEndpointGroup> groups) {
        super(new EndpointMapping(""), AdditionalHealthEndpointPathsWebMvcHandlerMapping.asList(healthEndpoint), null, false);
        this.healthEndpoint = healthEndpoint;
        this.groups = groups;
    }

    private static Collection<ExposableWebEndpoint> asList(ExposableWebEndpoint healthEndpoint) {
        return healthEndpoint != null ? Collections.singletonList(healthEndpoint) : Collections.emptyList();
    }

    @Override
    protected void initHandlerMethods() {
        if (this.healthEndpoint == null) {
            return;
        }
        for (WebOperation operation : this.healthEndpoint.getOperations()) {
            WebOperationRequestPredicate predicate = operation.getRequestPredicate();
            String matchAllRemainingPathSegmentsVariable = predicate.getMatchAllRemainingPathSegmentsVariable();
            if (matchAllRemainingPathSegmentsVariable == null) continue;
            for (HealthEndpointGroup group : this.groups) {
                AdditionalHealthEndpointPath additionalPath = group.getAdditionalPath();
                if (additionalPath == null) continue;
                this.registerMapping(this.healthEndpoint, predicate, operation, additionalPath.getValue());
            }
        }
    }

    @Override
    protected AbstractWebMvcEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return null;
    }
}

