/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.store.history.tsdb.greptime;

import io.greptime.GreptimeDB;
import io.greptime.models.AuthInfo;
import io.greptime.models.DataType;
import io.greptime.models.Result;
import io.greptime.models.Table;
import io.greptime.models.TableSchema;
import io.greptime.options.GreptimeOptions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.common.util.TimePeriodUtil;
import org.apache.hertzbeat.warehouse.store.history.tsdb.AbstractHistoryDataStorage;
import org.apache.hertzbeat.warehouse.store.history.tsdb.greptime.GreptimeProperties;
import org.apache.hertzbeat.warehouse.store.history.tsdb.vm.PromQlQueryContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(prefix="warehouse.store.greptime", name={"enabled"}, havingValue="true")
public class GreptimeDbDataStorage
extends AbstractHistoryDataStorage {
    private static final Logger log = LoggerFactory.getLogger(GreptimeDbDataStorage.class);
    private static final String BASIC = "Basic";
    private static final String QUERY_RANGE_PATH = "/v1/prometheus/api/v1/query_range";
    private static final String LABEL_KEY_NAME = "__name__";
    private static final String LABEL_KEY_FIELD = "__field__";
    private static final String LABEL_KEY_INSTANCE = "instance";
    private GreptimeDB greptimeDb;
    private final GreptimeProperties greptimeProperties;
    private final RestTemplate restTemplate;

    public GreptimeDbDataStorage(GreptimeProperties greptimeProperties, RestTemplate restTemplate) {
        if (greptimeProperties == null) {
            log.error("init error, please config Warehouse GreptimeDB props in application.yml");
            throw new IllegalArgumentException("please config Warehouse GreptimeDB props");
        }
        this.restTemplate = restTemplate;
        this.greptimeProperties = greptimeProperties;
        this.serverAvailable = this.initGreptimeDbClient(greptimeProperties);
    }

    private boolean initGreptimeDbClient(GreptimeProperties greptimeProperties) {
        String endpoints = greptimeProperties.grpcEndpoints();
        try {
            GreptimeOptions opts = GreptimeOptions.newBuilder((String[])endpoints.split(","), (String)greptimeProperties.database()).writeMaxRetries(3).authInfo(new AuthInfo(greptimeProperties.username(), greptimeProperties.password())).routeTableRefreshPeriodSeconds(30L).build();
            this.greptimeDb = GreptimeDB.create((GreptimeOptions)opts);
        }
        catch (Exception e) {
            log.error("[warehouse greptime] Fail to start GreptimeDB client");
            return false;
        }
        return true;
    }

    @Override
    public void saveData(CollectRep.MetricsData metricsData) {
        if (!this.isServerAvailable() || metricsData.getCode() != CollectRep.Code.SUCCESS) {
            return;
        }
        if (metricsData.getValues().isEmpty()) {
            log.info("[warehouse greptime] flush metrics data {} {}is null, ignore.", (Object)metricsData.getId(), (Object)metricsData.getMetrics());
            return;
        }
        String monitorId = String.valueOf(metricsData.getId());
        String tableName = this.getTableName(metricsData.getMetrics());
        TableSchema.Builder tableSchemaBuilder = TableSchema.newBuilder((String)tableName);
        tableSchemaBuilder.addTag(LABEL_KEY_INSTANCE, DataType.String).addTimestamp("ts", DataType.TimestampMillisecond);
        List fields = metricsData.getFields();
        fields.forEach(field -> {
            if (field.getLabel()) {
                tableSchemaBuilder.addTag(field.getName(), DataType.String);
            } else if (field.getType() == 0) {
                tableSchemaBuilder.addField(field.getName(), DataType.Float64);
            } else if (field.getType() == 1) {
                tableSchemaBuilder.addField(field.getName(), DataType.String);
            }
        });
        Table table = Table.from((TableSchema)tableSchemaBuilder.build());
        long now = System.currentTimeMillis();
        Object[] values = new Object[2 + fields.size()];
        values[0] = monitorId;
        values[1] = now;
        RowWrapper rowWrapper = metricsData.readRow();
        while (rowWrapper.hasNextRow()) {
            rowWrapper = rowWrapper.nextRow();
            AtomicInteger index = new AtomicInteger(-1);
            rowWrapper.cellStream().forEach(cell -> {
                index.getAndIncrement();
                if ("&nbsp;".equals(cell.getValue())) {
                    values[2 + index.get()] = null;
                    return;
                }
                Boolean label = cell.getMetadataAsBoolean("label");
                Byte type = cell.getMetadataAsByte("type");
                if (label.booleanValue()) {
                    values[2 + index.get()] = cell.getValue();
                } else if (type == 0) {
                    values[2 + index.get()] = Double.parseDouble(cell.getValue());
                } else if (type == 1) {
                    values[2 + index.get()] = cell.getValue();
                }
            });
            table.addRow(values);
        }
        CompletableFuture writeFuture = this.greptimeDb.write(new Table[]{table});
        try {
            Result result = (Result)writeFuture.get(10L, TimeUnit.SECONDS);
            if (result.isOk()) {
                log.debug("[warehouse greptime]-Write successful");
            } else {
                log.warn("[warehouse greptime]--Write failed: {}", result.getErr());
            }
        }
        catch (Throwable throwable) {
            log.error("[warehouse greptime]--Error occurred: {}", (Object)throwable.getMessage());
        }
    }

    @Override
    public Map<String, List<Value>> getHistoryMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        String name = this.getTableName(metrics);
        String timeSeriesSelector = "__name__=\"" + name + "\",instance=\"" + monitorId + "\"";
        if (!"prometheus".equals(app)) {
            timeSeriesSelector = timeSeriesSelector + ",__field__=\"" + metric + "\"";
        }
        HashMap<String, List<Value>> instanceValuesMap = new HashMap<String, List<Value>>(8);
        try {
            long start;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (StringUtils.hasText((String)this.greptimeProperties.username()) && StringUtils.hasText((String)this.greptimeProperties.password())) {
                String authStr = this.greptimeProperties.username() + ":" + this.greptimeProperties.password();
                String encodedAuth = Base64Util.encode((String)authStr);
                headers.add("Authorization", "Basic " + encodedAuth);
            }
            Instant now = Instant.now();
            try {
                if (NumberUtils.isParsable((String)history)) {
                    start = NumberUtils.toLong((String)history);
                    start = ZonedDateTime.now().toEpochSecond() - start;
                } else {
                    TemporalAmount temporalAmount = TimePeriodUtil.parseTokenTime((String)history);
                    assert (temporalAmount != null);
                    Instant dateTime = now.minus(temporalAmount);
                    start = dateTime.getEpochSecond();
                }
            }
            catch (Exception e) {
                log.error("history time error: {}. use default: 6h", (Object)e.getMessage());
                start = now.minus(6L, ChronoUnit.HOURS).getEpochSecond();
            }
            long end = now.getEpochSecond();
            String step = "60s";
            if (end - start < Duration.ofDays(7L).getSeconds() && end - start > Duration.ofDays(1L).getSeconds()) {
                step = "1h";
            } else if (end - start >= Duration.ofDays(7L).getSeconds()) {
                step = "4h";
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            URI uri = UriComponentsBuilder.fromUriString((String)(this.greptimeProperties.httpEndpoint() + QUERY_RANGE_PATH)).queryParam(URLEncoder.encode("query", StandardCharsets.UTF_8), new Object[]{URLEncoder.encode("{" + timeSeriesSelector + "}", StandardCharsets.UTF_8)}).queryParam("start", new Object[]{start}).queryParam("end", new Object[]{end}).queryParam("step", new Object[]{step}).queryParam("db", new Object[]{this.greptimeProperties.database()}).build(true).toUri();
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, PromQlQueryContent.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                log.debug("query metrics data from greptime success. {}", (Object)uri);
                if (responseEntity.getBody() != null && ((PromQlQueryContent)responseEntity.getBody()).getData() != null && ((PromQlQueryContent)responseEntity.getBody()).getData().getResult() != null) {
                    List<PromQlQueryContent.ContentData.Content> contents = ((PromQlQueryContent)responseEntity.getBody()).getData().getResult();
                    for (PromQlQueryContent.ContentData.Content content : contents) {
                        Map<String, String> labels = content.getMetric();
                        labels.remove(LABEL_KEY_NAME);
                        labels.remove(LABEL_KEY_INSTANCE);
                        String labelStr = JsonUtil.toJson(labels);
                        if (content.getValues() == null || content.getValues().isEmpty()) continue;
                        List valueList = instanceValuesMap.computeIfAbsent(labelStr, k -> new LinkedList());
                        for (Object[] valueArr : content.getValues()) {
                            long timestamp = ((Double)valueArr[0]).longValue();
                            String value = new BigDecimal(String.valueOf(valueArr[1])).setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
                            valueList.add(new Value(value, timestamp * 1000L));
                        }
                    }
                }
            } else {
                log.error("query metrics data from greptime failed. {}", (Object)responseEntity);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return instanceValuesMap;
    }

    private String getTableName(String metrics) {
        return metrics;
    }

    @Override
    public Map<String, List<Value>> getHistoryIntervalMetricData(Long monitorId, String app, String metrics, String metric, String label, String history) {
        return this.getHistoryMetricData(monitorId, app, metrics, metric, label, history);
    }

    public void destroy() {
        if (this.greptimeDb != null) {
            this.greptimeDb.shutdownGracefully();
            this.greptimeDb = null;
        }
    }
}

