/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.service.impl;

import java.util.Collections;
import java.util.List;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.warehouse.service.WarehouseService;
import org.apache.hertzbeat.warehouse.store.realtime.AbstractRealTimeDataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WarehouseServiceImpl
implements WarehouseService {
    private static final Logger log = LoggerFactory.getLogger(WarehouseServiceImpl.class);
    private final AbstractRealTimeDataStorage realTimeDataStorage;

    public WarehouseServiceImpl(AbstractRealTimeDataStorage realTimeDataStorage) {
        this.realTimeDataStorage = realTimeDataStorage;
    }

    @Override
    public List<CollectRep.MetricsData> queryMonitorMetricsData(Long monitorId) {
        boolean available = this.realTimeDataStorage.isServerAvailable();
        if (!available) {
            log.error("real time store not available");
            return Collections.emptyList();
        }
        return this.realTimeDataStorage.getCurrentMetricsData(monitorId);
    }
}

