/*
 * Decompiled with CFR 0.152.
 */
package io.greptime;

import io.greptime.Health;
import io.greptime.Router;
import io.greptime.Util;
import io.greptime.common.Display;
import io.greptime.common.Endpoint;
import io.greptime.common.Lifecycle;
import io.greptime.common.util.Ensures;
import io.greptime.common.util.SharedScheduledPool;
import io.greptime.options.RouterOptions;
import io.greptime.rpc.Context;
import io.greptime.rpc.Observer;
import io.greptime.rpc.RpcClient;
import io.greptime.v1.Health;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterClient
implements Lifecycle<RouterOptions>,
Health,
Display {
    private static final Logger LOG = LoggerFactory.getLogger(RouterClient.class);
    private static final SharedScheduledPool REFRESHER_POOL = Util.getSharedScheduledPool("route_cache_refresher", 1);
    private final AtomicLong refreshSequencer = new AtomicLong(0L);
    private ScheduledExecutorService refresher;
    private RouterOptions opts;
    private RpcClient rpcClient;
    private Router<Void, Endpoint> router;

    public boolean init(RouterOptions opts) {
        this.opts = ((RouterOptions)Ensures.ensureNonNull((Object)opts, (String)"null `RouterClient.opts`")).copy();
        this.rpcClient = this.opts.getRpcClient();
        List endpoints = (List)Ensures.ensureNonNull(this.opts.getEndpoints(), (String)"null `endpoints`");
        this.router = new DefaultRouter();
        this.router.onRefresh(endpoints, null);
        long refreshPeriod = this.opts.getRefreshPeriodSeconds();
        if (refreshPeriod > 0L) {
            this.refresher = (ScheduledExecutorService)REFRESHER_POOL.getObject();
            this.refresher.scheduleWithFixedDelay(() -> {
                long thisSequence = this.refreshSequencer.incrementAndGet();
                this.checkHealth().whenComplete((r, t) -> {
                    if (t != null) {
                        LOG.warn("Failed to check health", t);
                        return;
                    }
                    AtomicLong atomicLong = this.refreshSequencer;
                    synchronized (atomicLong) {
                        if (thisSequence < this.refreshSequencer.get()) {
                            LOG.warn("Skip outdated health check result, sequence: {}", (Object)thisSequence);
                            return;
                        }
                        ArrayList activities = new ArrayList();
                        ArrayList inactivities = new ArrayList();
                        for (Map.Entry entry : r.entrySet()) {
                            if (((Boolean)entry.getValue()).booleanValue()) {
                                activities.add(entry.getKey());
                                continue;
                            }
                            inactivities.add(entry.getKey());
                        }
                        this.router.onRefresh(activities, inactivities);
                    }
                });
            }, Util.randomInitialDelay(180L), refreshPeriod, TimeUnit.SECONDS);
            LOG.info("Router cache refresher started.");
        }
        return true;
    }

    public void shutdownGracefully() {
        if (this.rpcClient != null) {
            this.rpcClient.shutdownGracefully();
        }
        if (this.refresher != null) {
            REFRESHER_POOL.returnObject((Object)this.refresher);
            this.refresher = null;
        }
    }

    public CompletableFuture<Endpoint> route() {
        return this.router.routeFor(null);
    }

    public <Req, Resp> CompletableFuture<Resp> invoke(Endpoint endpoint, Req request, Context ctx) {
        return this.invoke(endpoint, request, ctx, -1L);
    }

    public <Req, Resp> CompletableFuture<Resp> invoke(Endpoint endpoint, Req request, Context ctx, long timeoutMs) {
        final CompletableFuture future = new CompletableFuture();
        try {
            this.rpcClient.invokeAsync(endpoint, request, ctx, new Observer<Resp>(){

                public void onNext(Resp value) {
                    future.complete(value);
                }

                public void onError(Throwable err) {
                    future.completeExceptionally(err);
                }
            }, timeoutMs);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public <Req, Resp> void invokeServerStreaming(Endpoint endpoint, Req request, Context ctx, Observer<Resp> observer) {
        try {
            this.rpcClient.invokeServerStreaming(endpoint, request, ctx, observer);
        }
        catch (Exception e) {
            observer.onError((Throwable)e);
        }
    }

    public <Req, Resp> Observer<Req> invokeClientStreaming(Endpoint endpoint, Req defaultReqIns, Context ctx, Observer<Resp> respObserver) {
        try {
            return this.rpcClient.invokeClientStreaming(endpoint, defaultReqIns, ctx, respObserver);
        }
        catch (Exception e) {
            respObserver.onError((Throwable)e);
            return new Observer.RejectedObserver((Throwable)e);
        }
    }

    public void display(Display.Printer out) {
        out.println((Object)"--- RouterClient ---").print((Object)"opts=").println((Object)this.opts);
        if (this.rpcClient != null) {
            out.println((Object)"");
            this.rpcClient.display(out);
        }
        out.println((Object)"");
    }

    public String toString() {
        return "RouterClient{refresher=" + this.refresher + ", opts=" + this.opts + ", rpcClient=" + this.rpcClient + '}';
    }

    @Override
    public CompletableFuture<Map<Endpoint, Boolean>> checkHealth() {
        Map futures = this.opts.getEndpoints().stream().collect(Collectors.toMap(Function.identity(), this::doCheckHealth));
        CompletableFuture<Void> all = CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0]));
        return all.thenApply(ok -> futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Boolean)((CompletableFuture)e.getValue()).join())));
    }

    private CompletableFuture<Boolean> doCheckHealth(Endpoint endpoint) {
        Health.HealthCheckRequest req = Health.HealthCheckRequest.newBuilder().build();
        return ((CompletableFuture)this.invoke(endpoint, req, Context.newDefault(), this.opts.getCheckHealthTimeoutMs()).thenApply(resp -> true)).exceptionally(t -> {
            LOG.warn("Failed to check health for endpoint: {}", (Object)endpoint, t);
            return false;
        });
    }

    static class Endpoints {
        final List<Endpoint> activities;
        final List<Endpoint> inactivities;

        Endpoints(List<Endpoint> activities, List<Endpoint> inactivities) {
            this.activities = activities == null ? new ArrayList() : activities;
            this.inactivities = inactivities == null ? new ArrayList() : inactivities;
        }
    }

    private static class DefaultRouter
    implements Router<Void, Endpoint> {
        private final AtomicReference<Endpoints> endpointsRef = new AtomicReference();

        private DefaultRouter() {
        }

        @Override
        public CompletableFuture<Endpoint> routeFor(Void request) {
            Endpoints endpoints = this.endpointsRef.get();
            if (endpoints == null) {
                return Util.errorCf(new IllegalStateException("null `endpoints`"));
            }
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (!endpoints.activities.isEmpty()) {
                int i = random.nextInt(0, endpoints.activities.size());
                return Util.completedCf(endpoints.activities.get(i));
            }
            if (!endpoints.inactivities.isEmpty()) {
                int i = random.nextInt(0, endpoints.inactivities.size());
                Endpoint goodLuck = endpoints.inactivities.get(i);
                LOG.warn("No active endpoint, return an inactive one: {}", (Object)goodLuck);
                return Util.completedCf(goodLuck);
            }
            return Util.errorCf(new IllegalStateException("empty `endpoints`"));
        }

        @Override
        public void onRefresh(List<Endpoint> activities, List<Endpoint> inactivities) {
            LOG.info("Router cache refreshed, activities: {}, inactivities: {}", activities, inactivities);
            this.endpointsRef.set(new Endpoints(activities, inactivities));
        }
    }
}

