/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class TracingIterator<K, V>
implements Iterator<ConsumerRecord<K, V>> {
    private final Iterator<ConsumerRecord<K, V>> delegateIterator;
    private final Instrumenter<KafkaProcessRequest, Void> instrumenter;
    private final BooleanSupplier wrappingEnabled;
    private final Context parentContext;
    private final KafkaConsumerContext consumerContext;
    @Nullable
    private KafkaProcessRequest currentRequest;
    @Nullable
    private Context currentContext;
    @Nullable
    private Scope currentScope;

    private TracingIterator(Iterator<ConsumerRecord<K, V>> delegateIterator, Instrumenter<KafkaProcessRequest, Void> instrumenter, BooleanSupplier wrappingEnabled, KafkaConsumerContext consumerContext) {
        this.delegateIterator = delegateIterator;
        this.instrumenter = instrumenter;
        this.wrappingEnabled = wrappingEnabled;
        Context receiveContext = consumerContext.getContext();
        this.parentContext = receiveContext != null ? receiveContext : Context.current();
        this.consumerContext = consumerContext;
    }

    public static <K, V> Iterator<ConsumerRecord<K, V>> wrap(Iterator<ConsumerRecord<K, V>> delegateIterator, Instrumenter<KafkaProcessRequest, Void> instrumenter, BooleanSupplier wrappingEnabled, KafkaConsumerContext consumerContext) {
        if (wrappingEnabled.getAsBoolean()) {
            return new TracingIterator<K, V>(delegateIterator, instrumenter, wrappingEnabled, consumerContext);
        }
        return delegateIterator;
    }

    @Override
    public boolean hasNext() {
        this.closeScopeAndEndSpan();
        return this.delegateIterator.hasNext();
    }

    @Override
    public ConsumerRecord<K, V> next() {
        this.closeScopeAndEndSpan();
        ConsumerRecord<K, V> next = this.delegateIterator.next();
        if (next != null && this.wrappingEnabled.getAsBoolean()) {
            this.currentRequest = KafkaProcessRequest.create(this.consumerContext, next);
            this.currentContext = this.instrumenter.start(this.parentContext, (Object)this.currentRequest);
            this.currentScope = this.currentContext.makeCurrent();
        }
        return next;
    }

    private void closeScopeAndEndSpan() {
        if (this.currentScope != null) {
            this.currentScope.close();
            this.instrumenter.end(this.currentContext, (Object)this.currentRequest, null, null);
            this.currentScope = null;
            this.currentRequest = null;
            this.currentContext = null;
        }
    }

    @Override
    public void remove() {
        this.delegateIterator.remove();
    }
}

