/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.util.Map;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.util.WagedRebalanceUtil;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceConfig;

public class WagedResourceWeightsProvider {
    private final ResourceControllerDataProvider _clusterData;

    public WagedResourceWeightsProvider(ResourceControllerDataProvider clusterData) {
        this._clusterData = clusterData;
    }

    public Map<String, Integer> getPartitionWeights(String resourceName, String partition) {
        ResourceConfig resourceConfig = this._clusterData.getResourceConfig(resourceName);
        IdealState is = this._clusterData.getIdealState(resourceName);
        ResourceConfig mergedResourceConfig = ResourceConfig.mergeIdealStateWithResourceConfig(resourceConfig, is);
        return WagedRebalanceUtil.fetchCapacityUsage(partition, mergedResourceConfig, this._clusterData.getClusterConfig());
    }
}

