/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.ir.IRScope;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRBlockBody
extends IRBlockBody {
    protected final MethodHandle handle;
    protected final MethodHandle callHandle;
    protected final MethodHandle yieldDirectHandle;
    protected MethodHandle normalYieldHandle;
    protected MethodHandle normalYieldSpecificHandle;
    protected MethodHandle normalYieldUnwrapHandle;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle VALUE_TO_ARRAY = Binder.from(IRubyObject[].class, IRubyObject.class, new Class[0]).invokeStaticQuiet(LOOKUP, IRRuntimeHelpers.class, "singleBlockArgToArray");
    private static final MethodHandle WRAP_VALUE = Binder.from(IRubyObject[].class, IRubyObject.class, new Class[0]).invokeStaticQuiet(LOOKUP, CompiledIRBlockBody.class, "wrapValue");
    private static final MethodHandle CHECK_ARITY = Binder.from(Void.TYPE, ThreadContext.class, Block.class, IRubyObject[].class, Block.class).invokeStaticQuiet(LOOKUP, CompiledIRBlockBody.class, "checkArity");

    public CompiledIRBlockBody(MethodHandle handle, IRScope closure, long encodedSignature) {
        super(closure, Signature.decode(encodedSignature));
        this.handle = handle;
        MethodHandle callHandle = MethodHandles.insertArguments(handle, 2, closure.getStaticScope(), null);
        this.callHandle = MethodHandles.foldArguments(callHandle, CHECK_ARITY);
        this.yieldDirectHandle = MethodHandles.insertArguments(MethodHandles.insertArguments(handle, 2, closure.getStaticScope()), 4, Block.NULL_BLOCK);
        closure.getStaticScope().determineModule();
    }

    private static void checkArity(ThreadContext context, Block selfBlock, IRubyObject[] args2, Block block) {
        if (selfBlock.type == Block.Type.LAMBDA) {
            selfBlock.getSignature().checkArity(context.runtime, args2);
        }
    }

    private static IRubyObject[] wrapValue(IRubyObject value2) {
        return new IRubyObject[]{value2};
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public boolean canCallDirect() {
        return true;
    }

    public MethodHandle getCallHandle() {
        return this.callHandle;
    }

    public MethodHandle getNormalYieldSpecificHandle() {
        MethodHandle normalYieldSpecificHandle = this.normalYieldSpecificHandle;
        if (normalYieldSpecificHandle != null) {
            return normalYieldSpecificHandle;
        }
        this.normalYieldSpecificHandle = Binder.from(IRubyObject.class, ThreadContext.class, Block.class).append(new Class[]{StaticScope.class, IRubyObject.class, IRubyObject[].class, Block.class}, new Object[]{this.getStaticScope(), null, null, Block.NULL_BLOCK}).invoke(this.handle);
        return this.normalYieldSpecificHandle;
    }

    public MethodHandle getNormalYieldHandle() {
        MethodHandle normalYieldHandle = this.normalYieldHandle;
        if (normalYieldHandle != null) {
            return normalYieldHandle;
        }
        this.normalYieldHandle = Binder.from(IRubyObject.class, ThreadContext.class, Block.class, IRubyObject.class).filter(2, WRAP_VALUE).insert(2, new Class[]{StaticScope.class, IRubyObject.class}, new Object[]{this.getStaticScope(), null}).append(Block.class, (Object)Block.NULL_BLOCK).invoke(this.handle);
        return this.normalYieldHandle;
    }

    public MethodHandle getNormalYieldUnwrapHandle() {
        MethodHandle normalYieldUnwrapHandle = this.normalYieldUnwrapHandle;
        if (normalYieldUnwrapHandle != null) {
            return normalYieldUnwrapHandle;
        }
        this.normalYieldUnwrapHandle = Binder.from(IRubyObject.class, ThreadContext.class, Block.class, IRubyObject.class).filter(2, VALUE_TO_ARRAY).insert(2, new Class[]{StaticScope.class, IRubyObject.class}, new Object[]{this.getStaticScope(), null}).append(Block.class, (Object)Block.NULL_BLOCK).invoke(this.handle);
        return this.normalYieldUnwrapHandle;
    }

    @Override
    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        try {
            return this.callHandle.invokeExact(context, block, args2, blockArg);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        try {
            return this.yieldDirectHandle.invokeExact(context, block, self2, args2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, Block block, Block.Type type2, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
        throw new UnsupportedOperationException("commonYieldPath not implemented");
    }
}

