/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.xz.LzmaCompressor;
import org.apache.hadoop.hbase.io.compress.xz.LzmaDecompressor;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@Deprecated
public class LzmaCodec
implements Configurable,
CompressionCodec {
    public static final String LZMA_LEVEL_KEY = "hbase.io.compress.lzma.level";
    public static final int LZMA_LEVEL_DEFAULT = 6;
    public static final String LZMA_BUFFERSIZE_KEY = "hbase.io.compress.lzma.buffersize";
    public static final int LZMA_BUFFERSIZE_DEFAULT = 262144;
    private Configuration conf = new Configuration();
    private int bufferSize = LzmaCodec.getBufferSize(this.conf);
    private int level = LzmaCodec.getLevel(this.conf);

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bufferSize = LzmaCodec.getBufferSize(conf);
        this.level = LzmaCodec.getLevel(conf);
    }

    public Compressor createCompressor() {
        return new LzmaCompressor(this.level, this.bufferSize);
    }

    public Decompressor createDecompressor() {
        return new LzmaDecompressor(this.bufferSize);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, CompressionUtil.compressionOverhead((int)this.bufferSize));
    }

    public Class<? extends Compressor> getCompressorType() {
        return LzmaCompressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return LzmaDecompressor.class;
    }

    public String getDefaultExtension() {
        return ".lzma";
    }

    static int getLevel(Configuration conf) {
        return conf.getInt(LZMA_LEVEL_KEY, 6);
    }

    static int getBufferSize(Configuration conf) {
        return conf.getInt(LZMA_BUFFERSIZE_KEY, 262144);
    }
}

