/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.Objects;
import org.apache.hadoop.hbase.TableName;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class GetUserPermissionsRequest {
    private String userName;
    private String namespace;
    private TableName tableName;
    private byte[] family;
    private byte[] qualifier;

    private GetUserPermissionsRequest(String userName, String namespace, TableName tableName, byte[] family, byte[] qualifier) {
        this.userName = userName;
        this.namespace = namespace;
        this.tableName = tableName;
        this.family = family;
        this.qualifier = qualifier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String namespace) {
        return new Builder(namespace);
    }

    public static Builder newBuilder(TableName tableName) {
        return new Builder(tableName);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public static final class Builder {
        private String userName;
        private String namespace;
        private TableName tableName;
        private byte[] family;
        private byte[] qualifier;

        private Builder() {
        }

        private Builder(String namespace) {
            this.namespace = namespace;
        }

        private Builder(TableName tableName) {
            this.tableName = tableName;
        }

        public Builder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder withFamily(byte[] family) {
            Objects.requireNonNull(this.tableName, "The tableName can't be NULL");
            this.family = family;
            return this;
        }

        public Builder withQualifier(byte[] qualifier) {
            Objects.requireNonNull(this.tableName, "The tableName can't be NULL");
            this.qualifier = qualifier;
            return this;
        }

        public GetUserPermissionsRequest build() {
            return new GetUserPermissionsRequest(this.userName, this.namespace, this.tableName, this.family, this.qualifier);
        }
    }
}

