/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorageType;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ZKReplicationQueueStorage;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ReplicationStorageFactory {
    public static final String REPLICATION_PEER_STORAGE_IMPL = "hbase.replication.peer.storage.impl";
    public static final ReplicationPeerStorageType DEFAULT_REPLICATION_PEER_STORAGE_IMPL = ReplicationPeerStorageType.ZOOKEEPER;

    private ReplicationStorageFactory() {
    }

    private static Class<? extends ReplicationPeerStorage> getReplicationPeerStorageClass(Configuration conf) {
        try {
            ReplicationPeerStorageType type = ReplicationPeerStorageType.valueOf(conf.get(REPLICATION_PEER_STORAGE_IMPL, DEFAULT_REPLICATION_PEER_STORAGE_IMPL.name()).toUpperCase());
            return type.getClazz();
        }
        catch (IllegalArgumentException e) {
            return conf.getClass(REPLICATION_PEER_STORAGE_IMPL, DEFAULT_REPLICATION_PEER_STORAGE_IMPL.getClazz(), ReplicationPeerStorage.class);
        }
    }

    public static ReplicationPeerStorage getReplicationPeerStorage(FileSystem fs, ZKWatcher zk, Configuration conf) {
        Class<? extends ReplicationPeerStorage> clazz = ReplicationStorageFactory.getReplicationPeerStorageClass(conf);
        for (Constructor<?> c : clazz.getConstructors()) {
            if (c.getParameterCount() != 2) continue;
            if (c.getParameterTypes()[0].isAssignableFrom(FileSystem.class)) {
                return (ReplicationPeerStorage)ReflectionUtils.newInstance(clazz, (Object[])new Object[]{fs, conf});
            }
            if (!c.getParameterTypes()[0].isAssignableFrom(ZKWatcher.class)) continue;
            return (ReplicationPeerStorage)ReflectionUtils.newInstance(clazz, (Object[])new Object[]{zk, conf});
        }
        throw new IllegalArgumentException("Can not create replication peer storage with type " + clazz);
    }

    public static ReplicationQueueStorage getReplicationQueueStorage(ZKWatcher zk, Configuration conf) {
        return new ZKReplicationQueueStorage(zk, conf);
    }
}

