/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.timelineservice;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorManager;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMTimelineCollectorManager
extends TimelineCollectorManager {
    private static final Logger LOG = LoggerFactory.getLogger(RMTimelineCollectorManager.class);
    private ResourceManager rm;

    public RMTimelineCollectorManager(ResourceManager resourceManager) {
        super(RMTimelineCollectorManager.class.getName());
        this.rm = resourceManager;
    }

    protected void doPostPut(ApplicationId appId, TimelineCollector collector) {
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(appId);
        if (app == null) {
            throw new YarnRuntimeException("Unable to get the timeline collector context info for a non-existing app " + appId);
        }
        String userId = app.getUser();
        TimelineCollectorContext context = collector.getTimelineEntityContext();
        if (userId != null && !userId.isEmpty()) {
            context.setUserId(userId);
        }
        context.setFlowName(TimelineUtils.generateDefaultFlowName((String)app.getName(), (ApplicationId)appId));
        context.setFlowVersion("1");
        context.setFlowRunId(app.getStartTime());
        for (String tag : app.getApplicationTags()) {
            String[] parts = tag.split(":", 2);
            if (parts.length != 2 || parts[1].isEmpty()) continue;
            switch (parts[0].toUpperCase()) {
                case "TIMELINE_FLOW_NAME_TAG": {
                    LOG.debug("Setting the flow name: {}", (Object)parts[1]);
                    context.setFlowName(parts[1]);
                    break;
                }
                case "TIMELINE_FLOW_VERSION_TAG": {
                    LOG.debug("Setting the flow version: {}", (Object)parts[1]);
                    context.setFlowVersion(parts[1]);
                    break;
                }
                case "TIMELINE_FLOW_RUN_ID_TAG": {
                    LOG.debug("Setting the flow run id: {}", (Object)parts[1]);
                    context.setFlowRunId(Long.parseLong(parts[1]));
                    break;
                }
            }
        }
    }
}

