/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.hbase.thirdparty.org.apache.commons.cli.PosixParser;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class WALPrettyPrinter {
    private static final Logger LOG = LoggerFactory.getLogger(WALPrettyPrinter.class);
    private static final String outputTmpl = "Sequence=%s, table=%s, region=%s, at write timestamp=%s";
    private boolean outputValues;
    private boolean outputJSON;
    private long sequence;
    private final Set<String> tableSet;
    private String region;
    private String row;
    private String rowPrefix;
    private boolean outputOnlyRowKey;
    private boolean persistentOutput;
    private boolean firstTxn;
    private PrintStream out;
    private static final Gson GSON = GsonUtil.createGson().create();
    private long position;

    public WALPrettyPrinter() {
        this(false, false, -1L, new HashSet<String>(), null, null, null, false, false, System.out);
    }

    public WALPrettyPrinter(boolean outputValues, boolean outputJSON, long sequence, Set<String> tableSet, String region, String row, String rowPrefix, boolean outputOnlyRowKey, boolean persistentOutput, PrintStream out) {
        this.outputValues = outputValues;
        this.outputJSON = outputJSON;
        this.sequence = sequence;
        this.tableSet = tableSet;
        this.region = region;
        this.row = row;
        this.rowPrefix = rowPrefix;
        this.outputOnlyRowKey = outputOnlyRowKey;
        this.persistentOutput = persistentOutput;
        if (persistentOutput) {
            this.beginPersistentOutput();
        }
        this.out = out;
        this.firstTxn = true;
    }

    public void enableValues() {
        this.outputValues = true;
    }

    public void disableValues() {
        this.outputValues = false;
    }

    public void enableJSON() {
        this.outputJSON = true;
    }

    public void disableJSON() {
        this.outputJSON = false;
    }

    public void setSequenceFilter(long sequence) {
        this.sequence = sequence;
    }

    public void setTableFilter(String tablesWithDelimiter) {
        Collections.addAll(this.tableSet, tablesWithDelimiter.split(","));
    }

    public void setRegionFilter(String region) {
        this.region = region;
    }

    public void setRowFilter(String row) {
        this.row = row;
    }

    public void setRowPrefixFilter(String rowPrefix) {
        this.rowPrefix = rowPrefix;
    }

    public void setOutputOnlyRowKey() {
        this.outputOnlyRowKey = true;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public void beginPersistentOutput() {
        if (this.persistentOutput) {
            return;
        }
        this.persistentOutput = true;
        this.firstTxn = true;
        if (this.outputJSON) {
            this.out.print("[");
        }
    }

    public void endPersistentOutput() {
        if (!this.persistentOutput) {
            return;
        }
        this.persistentOutput = false;
        if (this.outputJSON) {
            this.out.print("]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(Configuration conf, Path p) throws IOException {
        FileSystem fs = p.getFileSystem(conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.isFile(p)) {
            throw new IOException(p + " is not a file");
        }
        WAL.Reader log = WALFactory.createReader(fs, p, conf);
        if (log instanceof ProtobufLogReader) {
            String cellCodecClsName;
            List<String> writerClsNames = ((ProtobufLogReader)log).getWriterClsNames();
            if (writerClsNames != null && writerClsNames.size() > 0) {
                this.out.print("Writer Classes: ");
                for (int i = 0; i < writerClsNames.size(); ++i) {
                    this.out.print(writerClsNames.get(i));
                    if (i == writerClsNames.size() - 1) continue;
                    this.out.print(" ");
                }
                this.out.println();
            }
            if ((cellCodecClsName = ((ProtobufLogReader)log).getCodecClsName()) != null) {
                this.out.println("Cell Codec Class: " + cellCodecClsName);
            }
        }
        if (this.outputJSON && !this.persistentOutput) {
            this.out.print("[");
            this.firstTxn = true;
        }
        if (this.position > 0L) {
            log.seek(this.position);
        }
        try {
            WAL.Entry entry;
            while ((entry = log.next()) != null) {
                WALKeyImpl key = entry.getKey();
                WALEdit edit = entry.getEdit();
                Map<String, Object> txn = key.toStringMap();
                long writeTime = key.getWriteTime();
                if (!this.tableSet.isEmpty() && !this.tableSet.contains(txn.get("table").toString()) || this.sequence >= 0L && (Long)txn.get("sequence") != this.sequence || this.region != null && !txn.get("region").equals(this.region)) continue;
                ArrayList<HashMap<String, Object>> actions = new ArrayList<HashMap<String, Object>>();
                for (Cell cell : edit.getCells()) {
                    HashMap<String, Object> op = new HashMap<String, Object>(WALPrettyPrinter.toStringMap(cell, this.outputOnlyRowKey, this.rowPrefix, this.row, this.outputValues));
                    if (op.isEmpty()) continue;
                    actions.add(op);
                }
                if (actions.isEmpty()) continue;
                txn.put("actions", actions);
                if (this.outputJSON) {
                    if (this.firstTxn) {
                        this.firstTxn = false;
                    } else {
                        this.out.print(",");
                    }
                    this.out.print(GSON.toJson(txn));
                } else {
                    if (!this.outputOnlyRowKey) {
                        this.out.println(String.format(outputTmpl, txn.get("sequence"), txn.get("table"), txn.get("region"), new Date(writeTime)));
                    }
                    for (int i = 0; i < actions.size(); ++i) {
                        Map op = (Map)actions.get(i);
                        WALPrettyPrinter.printCell(this.out, op, this.outputValues, this.outputOnlyRowKey);
                    }
                }
                if (this.outputOnlyRowKey) continue;
                this.out.println("edit heap size: " + entry.getEdit().heapSize());
                this.out.println("position: " + log.getPosition());
            }
        }
        finally {
            log.close();
        }
        if (this.outputJSON && !this.persistentOutput) {
            this.out.print("]");
        }
    }

    public static void printCell(PrintStream out, Map<String, Object> op, boolean outputValues, boolean outputOnlyRowKey) {
        String rowDetails = "row=" + op.get("row");
        if (outputOnlyRowKey) {
            out.println(rowDetails);
            return;
        }
        rowDetails = rowDetails + ", column=" + op.get("family") + ":" + op.get("qualifier");
        rowDetails = rowDetails + ", timestamp=" + op.get("timestamp");
        rowDetails = rowDetails + ", type=" + op.get("type");
        out.println(rowDetails);
        if (op.get("tag") != null) {
            out.println("    tag: " + op.get("tag"));
        }
        if (outputValues) {
            out.println("    value: " + op.get("value"));
        }
        out.println("cell total size sum: " + op.get("total_size_sum"));
    }

    public static Map<String, Object> toStringMap(Cell cell, boolean printRowKeyOnly, String rowPrefix, String row, boolean outputValues) {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        String rowKey = Bytes.toStringBinary(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
        if (!Strings.isNullOrEmpty(rowPrefix) && !rowKey.startsWith(rowPrefix) || !Strings.isNullOrEmpty(row) && !rowKey.equals(row)) {
            return stringMap;
        }
        stringMap.put("row", rowKey);
        if (printRowKeyOnly) {
            return stringMap;
        }
        stringMap.put("type", (Object)cell.getType());
        stringMap.put("family", Bytes.toStringBinary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
        stringMap.put("qualifier", Bytes.toStringBinary(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
        stringMap.put("timestamp", cell.getTimestamp());
        stringMap.put("vlen", cell.getValueLength());
        stringMap.put("total_size_sum", cell.heapSize());
        if (cell.getTagsLength() > 0) {
            ArrayList<String> tagsString = new ArrayList<String>();
            Iterator<Tag> tagsIterator = PrivateCellUtil.tagsIterator(cell);
            while (tagsIterator.hasNext()) {
                Tag tag = tagsIterator.next();
                tagsString.add(tag.getType() + ":" + Bytes.toStringBinary(Tag.cloneValue(tag)));
            }
            stringMap.put("tag", tagsString);
        }
        if (outputValues) {
            stringMap.put("value", Bytes.toStringBinary(CellUtil.cloneValue(cell)));
        }
        return stringMap;
    }

    public static Map<String, Object> toStringMap(Cell cell) {
        return WALPrettyPrinter.toStringMap(cell, false, null, null, false);
    }

    public static void main(String[] args) throws IOException {
        WALPrettyPrinter.run(args);
    }

    public static void run(String[] args) throws IOException {
        HelpFormatter formatter;
        Options options = new Options();
        options.addOption("h", "help", false, "Output help message");
        options.addOption("j", "json", false, "Output JSON");
        options.addOption("p", "printvals", false, "Print values");
        options.addOption("t", "tables", true, "Table names (comma separated) to filter by; eg: test1,test2,test3 ");
        options.addOption("r", "region", true, "Region to filter by. Pass encoded region name; e.g. '9192caead6a5a20acb4454ffbc79fa14'");
        options.addOption("s", "sequence", true, "Sequence to filter by. Pass sequence number.");
        options.addOption("k", "outputOnlyRowKey", false, "Print only row keys");
        options.addOption("w", "row", true, "Row to filter by. Pass row name.");
        options.addOption("f", "rowPrefix", true, "Row prefix to filter by.");
        options.addOption("g", "goto", true, "Position to seek to in the file");
        WALPrettyPrinter printer = new WALPrettyPrinter();
        PosixParser parser = new PosixParser();
        List<String> files = null;
        try {
            CommandLine cmd = parser.parse(options, args);
            files = cmd.getArgList();
            if (files.isEmpty() || cmd.hasOption("h")) {
                formatter = new HelpFormatter();
                formatter.printHelp("WAL <filename...>", options, true);
                System.exit(-1);
            }
            if (cmd.hasOption("p")) {
                printer.enableValues();
            }
            if (cmd.hasOption("j")) {
                printer.enableJSON();
            }
            if (cmd.hasOption("k")) {
                printer.setOutputOnlyRowKey();
            }
            if (cmd.hasOption("t")) {
                printer.setTableFilter(cmd.getOptionValue("t"));
            }
            if (cmd.hasOption("r")) {
                printer.setRegionFilter(cmd.getOptionValue("r"));
            }
            if (cmd.hasOption("s")) {
                printer.setSequenceFilter(Long.parseLong(cmd.getOptionValue("s")));
            }
            if (cmd.hasOption("w")) {
                if (cmd.hasOption("f")) {
                    throw new ParseException("Row and Row-prefix cannot be supplied together");
                }
                printer.setRowFilter(cmd.getOptionValue("w"));
            }
            if (cmd.hasOption("f")) {
                if (cmd.hasOption("w")) {
                    throw new ParseException("Row and Row-prefix cannot be supplied together");
                }
                printer.setRowPrefixFilter(cmd.getOptionValue("f"));
            }
            if (cmd.hasOption("g")) {
                printer.setPosition(Long.parseLong(cmd.getOptionValue("g")));
            }
        }
        catch (ParseException e) {
            LOG.error("Failed to parse commandLine arguments", (Throwable)e);
            formatter = new HelpFormatter();
            formatter.printHelp("HFile filename(s) ", options, true);
            System.exit(-1);
        }
        Configuration conf = HBaseConfiguration.create();
        CommonFSUtils.setFsDefault(conf, CommonFSUtils.getRootDir(conf));
        printer.beginPersistentOutput();
        for (String f : files) {
            Path file = new Path(f);
            FileSystem fs = file.getFileSystem(conf);
            if (!fs.exists(file)) {
                System.err.println("ERROR, file doesnt exist: " + file);
                return;
            }
            printer.processFile(conf, file);
        }
        printer.endPersistentOutput();
    }
}

