/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureStoreTracker;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@Deprecated
@InterfaceAudience.Private
class BitSetNode {
    private static final long WORD_MASK = -1L;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int MAX_NODE_SIZE = 256;
    private boolean partial;
    private long[] modified;
    private long[] deleted;
    private long start;

    public void dump() {
        int j;
        int i;
        System.out.printf("%06d:%06d min=%d max=%d%n", this.getStart(), this.getEnd(), this.getActiveMinProcId(), this.getActiveMaxProcId());
        System.out.println("Modified:");
        for (i = 0; i < this.modified.length; ++i) {
            for (j = 0; j < 64; ++j) {
                System.out.print((this.modified[i] & 1L << j) != 0L ? "1" : "0");
            }
            System.out.println(" " + i);
        }
        System.out.println();
        System.out.println("Delete:");
        for (i = 0; i < this.deleted.length; ++i) {
            for (j = 0; j < 64; ++j) {
                System.out.print((this.deleted[i] & 1L << j) != 0L ? "1" : "0");
            }
            System.out.println(" " + i);
        }
        System.out.println();
    }

    public BitSetNode(long procId, boolean partial) {
        this.start = BitSetNode.alignDown(procId);
        int count = 1;
        this.modified = new long[count];
        this.deleted = new long[count];
        if (!partial) {
            Arrays.fill(this.deleted, -1L);
        }
        this.partial = partial;
        this.updateState(procId, false);
    }

    public BitSetNode(ProcedureProtos.ProcedureStoreTracker.TrackerNode data) {
        this.start = data.getStartId();
        int size = data.getUpdatedCount();
        assert (size == data.getDeletedCount());
        this.modified = new long[size];
        this.deleted = new long[size];
        for (int i = 0; i < size; ++i) {
            this.modified[i] = data.getUpdated(i);
            this.deleted[i] = data.getDeleted(i);
        }
        this.partial = false;
    }

    public BitSetNode(BitSetNode other, boolean resetDelete) {
        this.start = other.start;
        this.partial = resetDelete ? false : other.partial;
        this.modified = (long[])other.modified.clone();
        if (resetDelete) {
            this.deleted = new long[other.deleted.length];
            for (int i = 0; i < this.deleted.length; ++i) {
                int n = i;
                this.deleted[n] = this.deleted[n] | other.modified[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.deleted = (long[])other.deleted.clone();
        }
    }

    public void insertOrUpdate(long procId) {
        this.updateState(procId, false);
    }

    public void delete(long procId) {
        this.updateState(procId, true);
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.start + (long)(this.modified.length << 6) - 1L;
    }

    public boolean contains(long procId) {
        return this.start <= procId && procId <= this.getEnd();
    }

    public ProcedureStoreTracker.DeleteState isDeleted(long procId) {
        int bitmapIndex = this.getBitmapIndex(procId);
        int wordIndex = bitmapIndex >> 6;
        if (wordIndex >= this.deleted.length) {
            return ProcedureStoreTracker.DeleteState.MAYBE;
        }
        return (this.deleted[wordIndex] & 1L << bitmapIndex) != 0L ? ProcedureStoreTracker.DeleteState.YES : ProcedureStoreTracker.DeleteState.NO;
    }

    public boolean isModified(long procId) {
        int bitmapIndex = this.getBitmapIndex(procId);
        int wordIndex = bitmapIndex >> 6;
        if (wordIndex >= this.modified.length) {
            return false;
        }
        return (this.modified[wordIndex] & 1L << bitmapIndex) != 0L;
    }

    public boolean isAllModified() {
        for (int i = 0; i < this.modified.length; ++i) {
            if ((this.modified[i] | this.deleted[i]) == -1L) continue;
            return false;
        }
        return true;
    }

    public long[] getActiveProcIds() {
        ArrayList<Long> procIds = new ArrayList<Long>();
        for (int wordIndex = 0; wordIndex < this.modified.length; ++wordIndex) {
            if (this.deleted[wordIndex] == -1L || this.modified[wordIndex] == 0L) continue;
            long baseProcId = this.getStart() + (long)(wordIndex << 6);
            for (int i = 0; i < 64; ++i) {
                long mask = 1L << i;
                if ((this.deleted[wordIndex] & mask) != 0L || (this.modified[wordIndex] & mask) == 0L) continue;
                procIds.add(baseProcId + (long)i);
            }
        }
        return procIds.stream().mapToLong(Long::longValue).toArray();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.deleted.length; ++i) {
            if (this.deleted[i] == -1L) continue;
            return false;
        }
        return true;
    }

    public void resetModified() {
        Arrays.fill(this.modified, 0L);
    }

    public void unsetPartialFlag() {
        this.partial = false;
        for (int i = 0; i < this.modified.length; ++i) {
            for (int j = 0; j < 64; ++j) {
                if ((this.modified[i] & 1L << j) != 0L) continue;
                int n = i;
                this.deleted[n] = this.deleted[n] | 1L << j;
            }
        }
    }

    public ProcedureProtos.ProcedureStoreTracker.TrackerNode convert() {
        ProcedureProtos.ProcedureStoreTracker.TrackerNode.Builder builder = ProcedureProtos.ProcedureStoreTracker.TrackerNode.newBuilder();
        builder.setStartId(this.start);
        for (int i = 0; i < this.modified.length; ++i) {
            builder.addUpdated(this.modified[i]);
            builder.addDeleted(this.deleted[i]);
        }
        return builder.build();
    }

    public boolean canGrow(long procId) {
        if (procId <= this.start) {
            return this.getEnd() - procId < 256L;
        }
        return procId - this.start < 256L;
    }

    public boolean canMerge(BitSetNode rightNode) {
        assert (this.start < rightNode.start);
        return rightNode.getEnd() - this.start < 256L;
    }

    public void grow(long procId) {
        assert (this.canGrow(procId));
        if (procId < this.start) {
            long newStart = BitSetNode.alignDown(procId);
            int delta = (int)(this.start - newStart) >> 6;
            this.start = newStart;
            long[] newModified = new long[this.modified.length + delta];
            System.arraycopy(this.modified, 0, newModified, delta, this.modified.length);
            this.modified = newModified;
            long[] newDeleted = new long[this.deleted.length + delta];
            if (!this.partial) {
                for (int i = 0; i < delta; ++i) {
                    newDeleted[i] = -1L;
                }
            }
            System.arraycopy(this.deleted, 0, newDeleted, delta, this.deleted.length);
            this.deleted = newDeleted;
        } else {
            long newEnd = BitSetNode.alignUp(procId + 1L);
            int delta = (int)(newEnd - this.getEnd()) >> 6;
            int newSize = this.modified.length + delta;
            long[] newModified = Arrays.copyOf(this.modified, newSize);
            this.modified = newModified;
            long[] newDeleted = Arrays.copyOf(this.deleted, newSize);
            if (!this.partial) {
                for (int i = this.deleted.length; i < newSize; ++i) {
                    newDeleted[i] = -1L;
                }
            }
            this.deleted = newDeleted;
        }
    }

    public void merge(BitSetNode rightNode) {
        assert (this.start < rightNode.start);
        int newSize = (int)(rightNode.getEnd() - this.start + 1L) >> 6;
        long[] newModified = Arrays.copyOf(this.modified, newSize);
        System.arraycopy(rightNode.modified, 0, newModified, newSize - rightNode.modified.length, rightNode.modified.length);
        long[] newDeleted = Arrays.copyOf(this.deleted, newSize);
        System.arraycopy(rightNode.deleted, 0, newDeleted, newSize - rightNode.deleted.length, rightNode.deleted.length);
        if (!this.partial) {
            int n = newSize - rightNode.deleted.length;
            for (int i = this.deleted.length; i < n; ++i) {
                newDeleted[i] = -1L;
            }
        }
        this.modified = newModified;
        this.deleted = newDeleted;
    }

    public String toString() {
        return "BitSetNode(" + this.getStart() + "-" + this.getEnd() + ")";
    }

    public long getActiveMinProcId() {
        long minProcId = this.start;
        for (int i = 0; i < this.deleted.length; ++i) {
            if (this.deleted[i] == 0L) {
                return minProcId;
            }
            if (this.deleted[i] != -1L) {
                for (int j = 0; j < 64; ++j) {
                    if ((this.deleted[i] & 1L << j) != 0L) continue;
                    return minProcId + (long)j;
                }
            }
            minProcId += 64L;
        }
        return -1L;
    }

    public long getActiveMaxProcId() {
        long maxProcId = this.getEnd();
        for (int i = this.deleted.length - 1; i >= 0; --i) {
            if (this.deleted[i] == 0L) {
                return maxProcId;
            }
            if (this.deleted[i] != -1L) {
                for (int j = 63; j >= 0; --j) {
                    if ((this.deleted[i] & 1L << j) != 0L) continue;
                    return maxProcId - (long)(63 - j);
                }
            }
            maxProcId -= 64L;
        }
        return -1L;
    }

    private int getBitmapIndex(long procId) {
        return (int)(procId - this.start);
    }

    void updateState(long procId, boolean isDeleted) {
        int bitmapIndex = this.getBitmapIndex(procId);
        int wordIndex = bitmapIndex >> 6;
        long value = 1L << bitmapIndex;
        try {
            int n = wordIndex;
            this.modified[n] = this.modified[n] | value;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            ArrayIndexOutOfBoundsException aioobe2 = new ArrayIndexOutOfBoundsException("pid=" + procId + ", deleted=" + isDeleted);
            aioobe2.initCause(aioobe);
            throw aioobe2;
        }
        if (isDeleted) {
            int n = wordIndex;
            this.deleted[n] = this.deleted[n] | value;
        } else {
            int n = wordIndex;
            this.deleted[n] = this.deleted[n] & (value ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private static long alignUp(long x) {
        return x + 63L & 0xFFFFFFFFFFFFFFC0L;
    }

    private static long alignDown(long x) {
        return x & 0xFFFFFFFFFFFFFFC0L;
    }
}

