/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.util.StringUtils;

public final class RouterQuotaUsage
extends QuotaUsage {
    public static final long QUOTA_USAGE_COUNT_DEFAULT = 0L;

    private RouterQuotaUsage(Builder builder) {
        super((QuotaUsage.Builder)builder);
    }

    public void verifyNamespaceQuota() throws NSQuotaExceededException {
        long fileAndDirectoryCount;
        long quota = this.getQuota();
        if (Quota.isViolated((long)quota, (long)(fileAndDirectoryCount = this.getFileAndDirectoryCount()))) {
            throw new NSQuotaExceededException(quota, fileAndDirectoryCount);
        }
    }

    public void verifyStoragespaceQuota() throws DSQuotaExceededException {
        long spaceConsumed;
        long spaceQuota = this.getSpaceQuota();
        if (Quota.isViolated((long)spaceQuota, (long)(spaceConsumed = this.getSpaceConsumed()))) {
            throw new DSQuotaExceededException(spaceQuota, spaceConsumed);
        }
    }

    public void verifyQuotaByStorageType() throws DSQuotaExceededException {
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            long typeConsumed;
            long typeQuota = this.getTypeQuota(t);
            if (typeQuota == -1L || !Quota.isViolated((long)typeQuota, (long)(typeConsumed = this.getTypeConsumed(t)))) continue;
            throw new DSQuotaExceededException(typeQuota, typeConsumed);
        }
    }

    public String toString() {
        String nsQuota = "-";
        String nsCount = "-";
        long quota = this.getQuota();
        if (quota != -1L) {
            nsQuota = String.valueOf(quota);
            nsCount = String.valueOf(this.getFileAndDirectoryCount());
        }
        String ssQuota = "-";
        String ssCount = "-";
        long spaceQuota = this.getSpaceQuota();
        if (spaceQuota != -1L) {
            ssQuota = StringUtils.byteDesc((long)spaceQuota);
            ssCount = StringUtils.byteDesc((long)this.getSpaceConsumed());
        }
        StringBuilder str = new StringBuilder();
        str.append("[NsQuota: ").append(nsQuota).append("/").append(nsCount).append(", SsQuota: ").append(ssQuota).append("/").append(ssCount).append("]");
        return str.toString();
    }

    public static class Builder
    extends QuotaUsage.Builder {
        public RouterQuotaUsage build() {
            return new RouterQuotaUsage(this);
        }

        public Builder fileAndDirectoryCount(long count) {
            super.fileAndDirectoryCount(count);
            return this;
        }

        public Builder quota(long quota) {
            super.quota(quota);
            return this;
        }

        public Builder spaceConsumed(long spaceConsumed) {
            super.spaceConsumed(spaceConsumed);
            return this;
        }

        public Builder spaceQuota(long spaceQuota) {
            super.spaceQuota(spaceQuota);
            return this;
        }

        public Builder typeConsumed(long[] typeConsumed) {
            super.typeConsumed(typeConsumed);
            return this;
        }

        public Builder typeQuota(long[] typeQuota) {
            super.typeQuota(typeQuota);
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            super.typeQuota(type, quota);
            return this;
        }
    }
}

