/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.internal.operators.AbstractQueueWithResources;
import com.github.davidmoten.rx.internal.operators.QueueWithResources;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class QueueWithResourcesNonBlockingUnsubscribe<T>
extends AbstractQueueWithResources<T> {
    private volatile boolean unsubscribing = false;
    private final AtomicInteger currentCalls = new AtomicInteger(0);
    private final AtomicBoolean unsubscribed = new AtomicBoolean(false);

    QueueWithResourcesNonBlockingUnsubscribe(QueueWithResources<T> queue) {
        super(queue);
    }

    @Override
    public T poll() {
        try {
            Object t;
            if (this.unsubscribing) {
                T t2 = null;
                return t2;
            }
            try {
                this.currentCalls.incrementAndGet();
                t = super.poll();
                this.currentCalls.decrementAndGet();
            }
            catch (Throwable throwable) {
                this.currentCalls.decrementAndGet();
                throw throwable;
            }
            return t;
        }
        finally {
            this.checkUnsubscribe();
        }
    }

    @Override
    public boolean offer(T t) {
        try {
            boolean bl;
            if (this.unsubscribing) {
                boolean bl2 = true;
                return bl2;
            }
            try {
                this.currentCalls.incrementAndGet();
                bl = super.offer(t);
                this.currentCalls.decrementAndGet();
            }
            catch (Throwable throwable) {
                this.currentCalls.decrementAndGet();
                throw throwable;
            }
            return bl;
        }
        finally {
            this.checkUnsubscribe();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            boolean bl;
            if (this.unsubscribing) {
                boolean bl2 = true;
                return bl2;
            }
            try {
                this.currentCalls.incrementAndGet();
                bl = super.isEmpty();
                this.currentCalls.decrementAndGet();
            }
            catch (Throwable throwable) {
                this.currentCalls.decrementAndGet();
                throw throwable;
            }
            return bl;
        }
        finally {
            this.checkUnsubscribe();
        }
    }

    @Override
    public void unsubscribe() {
        this.unsubscribing = true;
        this.checkUnsubscribe();
    }

    private void checkUnsubscribe() {
        if (this.unsubscribing && this.currentCalls.get() == 0 && this.unsubscribed.compareAndSet(false, true)) {
            super.unsubscribe();
        }
    }

    @Override
    public void freeResources() {
        super.freeResources();
    }

    public boolean isUnsubscribed() {
        return this.unsubscribed.get();
    }

    @Override
    public long resourcesSize() {
        return super.resourcesSize();
    }
}

