/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.SecurityTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShm;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestBlockTokenWithShortCircuitRead {
    private static final int BLOCK_SIZE = 1024;
    private static final int FILE_SIZE = 2048;
    private static final String FILE_TO_SHORT_CIRCUIT_READ = "/fileToSSR.dat";

    private void readFile(FSDataInputStream in) throws IOException {
        int nRead;
        byte[] toRead = new byte[2048];
        int totalRead = 0;
        while ((nRead = in.read(toRead, totalRead, toRead.length - totalRead)) > 0) {
            totalRead += nRead;
        }
        Assert.assertEquals((String)"Cannot read file.", (long)toRead.length, (long)totalRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShortCircuitReadWithInvalidToken() throws Exception {
        MiniDFSCluster cluster = null;
        short numDataNodes = 1;
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 1024);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.replication", (int)numDataNodes);
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.setInt("dfs.client.retry.window.base", 10);
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "testShortCircuitReadWithInvalidToken").getAbsolutePath());
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.setInt("dfs.client.read.shortcircuit.streams.cache.size", 0);
        DomainSocket.disableBindPathValidation();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).format(true).build();
            cluster.waitActive();
            NameNode nn = cluster.getNameNode();
            NamenodeProtocols nnProto = nn.getRpcServer();
            BlockManager bm = nn.getNamesystem().getBlockManager();
            BlockTokenSecretManager sm = bm.getBlockTokenSecretManager();
            SecurityTestUtil.setBlockTokenLifetime(sm, 1000L);
            Path fileToRead = new Path(FILE_TO_SHORT_CIRCUIT_READ);
            DistributedFileSystem fs = cluster.getFileSystem();
            ShortCircuitCache cache = fs.getClient().getClientContext().getShortCircuitCache();
            DatanodeInfo datanode = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(cluster.getDataNodes().get(0).getDatanodeId()).build();
            cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

                public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) {
                    Assert.assertEquals((long)0L, (long)info.size());
                }
            });
            DFSTestUtil.createFile((FileSystem)fs, fileToRead, 2048L, numDataNodes, 0L);
            try (FSDataInputStream in = fs.open(fileToRead);){
                this.readFile(in);
                List locatedBlocks = nnProto.getBlockLocations(FILE_TO_SHORT_CIRCUIT_READ, 0L, 2048L).getLocatedBlocks();
                LocatedBlock lblock = (LocatedBlock)locatedBlocks.get(0);
                Token myToken = lblock.getBlockToken();
                Assert.assertFalse((boolean)SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)myToken));
                this.checkSlotsAfterSSRWithTokenExpiration(cache, datanode, in, (Token<BlockTokenIdentifier>)myToken);
                this.checkSlotsAfterSSRWithTokenExpiration(cache, datanode, in, (Token<BlockTokenIdentifier>)myToken);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            sockDir.close();
        }
    }

    private void checkSlotsAfterSSRWithTokenExpiration(ShortCircuitCache cache, DatanodeInfo datanode, FSDataInputStream in, Token<BlockTokenIdentifier> myToken) throws IOException {
        while (!SecurityTestUtil.isBlockTokenExpired(myToken)) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        in.seek(0L);
        this.readFile(in);
        this.checkShmAndSlots(cache, datanode, 1);
    }

    private void checkShmAndSlots(ShortCircuitCache cache, final DatanodeInfo datanode, final int expectedSlotCnt) throws IOException {
        cache.getDfsClientShmManager().visit(new DfsClientShmManager.Visitor(){

            public void visit(HashMap<DatanodeInfo, DfsClientShmManager.PerDatanodeVisitorInfo> info) {
                Assert.assertEquals((long)1L, (long)info.size());
                DfsClientShmManager.PerDatanodeVisitorInfo vinfo = info.get(datanode);
                Assert.assertFalse((boolean)vinfo.disabled);
                Assert.assertEquals((long)0L, (long)vinfo.full.size());
                Assert.assertEquals((long)1L, (long)vinfo.notFull.size());
                int slotCnt = 0;
                DfsClientShm shm = (DfsClientShm)vinfo.notFull.values().iterator().next();
                ShortCircuitShm.SlotIterator iter = shm.slotIterator();
                while (iter.hasNext()) {
                    iter.next();
                    ++slotCnt;
                }
                Assert.assertEquals((long)expectedSlotCnt, (long)slotCnt);
            }
        });
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
    }
}

