/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LeaseRecoverable;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.SafeMode;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDistributedFileSystem;
import org.apache.hadoop.hdfs.ViewDistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.functional.ConsumerRaisingIOE;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;

public class TestViewDistributedFileSystem
extends TestDistributedFileSystem {
    @Override
    HdfsConfiguration getTestConfiguration() {
        HdfsConfiguration conf = super.getTestConfiguration();
        conf.set("fs.hdfs.impl", ViewDistributedFileSystem.class.getName());
        return conf;
    }

    @Override
    public void testStatistics() throws IOException {
        FileSystem.getStatistics((String)"hdfs", ViewDistributedFileSystem.class).reset();
        ThreadLocal data = (ThreadLocal)Whitebox.getInternalState((Object)FileSystem.getStatistics((String)"hdfs", ViewDistributedFileSystem.class), (String)"threadData");
        data.set(null);
        super.testStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenWithPathHandle() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            Path openTestPath = new Path("/testOpen");
            fileSys.create(openTestPath).close();
            PathHandle pathHandle = fileSys.getPathHandle(fileSys.getFileStatus(openTestPath), new Options.HandleOpt[0]);
            fileSys.open(pathHandle, 1024).close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEmptyDelegationToken() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            ConfigUtil.addLinkFallback((Configuration)conf, (String)defaultUri.getHost(), (URI)defaultUri);
            try (FileSystem fileSys = FileSystem.get((Configuration)conf);){
                fileSys.getDelegationToken("");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithOptions() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            conf.set("fs.viewfs.mounttable." + defaultUri.getHost() + ".linkFallback", defaultUri.toString());
            conf.setLong("fs.trash.interval", 30000L);
            try (ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)conf);){
                Path testDir = new Path("/test");
                Path renameDir = new Path("/testRename");
                fileSystem.mkdirs(testDir);
                fileSystem.rename(testDir, renameDir, new Options.Rename[]{Options.Rename.TO_TRASH});
                Assert.assertTrue((boolean)fileSystem.exists(renameDir));
                Assert.assertFalse((boolean)fileSystem.exists(testDir));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithOptionsWithMountEntries() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            conf.set("fs.viewfs.mounttable." + defaultUri.getHost() + ".linkFallback", defaultUri.toString());
            Path target = new Path(defaultUri.toString(), "/src");
            ConfigUtil.addLink((Configuration)conf, (String)defaultUri.getHost(), (String)"/source", (URI)target.toUri());
            FileSystem defaultFs = FileSystem.get((URI)defaultUri, (Configuration)conf);
            defaultFs.mkdirs(target);
            try (ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)conf);){
                Path testDir = new Path("/source");
                Path filePath = new Path(testDir, "file");
                Path renamedFilePath = new Path(testDir, "fileRename");
                fileSystem.create(filePath).close();
                Assert.assertTrue((boolean)fileSystem.exists(filePath));
                fileSystem.rename(filePath, renamedFilePath, new Options.Rename[]{Options.Rename.NONE});
                Assert.assertFalse((boolean)fileSystem.exists(filePath));
                Assert.assertTrue((boolean)fileSystem.exists(renamedFilePath));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuota() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            URI defaultUri = URI.create(conf.get("fs.defaultFS"));
            conf.set("fs.viewfs.mounttable." + defaultUri.getHost() + ".linkFallback", defaultUri.toString());
            Path target = new Path(defaultUri.toString(), "/src");
            ConfigUtil.addLink((Configuration)conf, (String)defaultUri.getHost(), (String)"/source", (URI)target.toUri());
            FileSystem defaultFs = FileSystem.get((URI)defaultUri, (Configuration)conf);
            defaultFs.mkdirs(target);
            try (ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)conf);){
                Path testDir = new Path("/source");
                fileSystem.setQuota(testDir, 10L, 10L);
                Assert.assertEquals((long)10L, (long)defaultFs.getQuotaUsage(target).getSpaceQuota());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testPathCapabilities() throws IOException {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.getViewFsConfiguration()).numDataNodes(0).build();
             ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)cluster.getConfiguration(0));){
            Path testFile = new Path("/test");
            Assert.assertTrue((String)"ViewDfs supports truncate", (boolean)fileSystem.hasPathCapability(testFile, "fs.capability.paths.truncate"));
            boolean isLeaseRecoverable = fileSystem.hasPathCapability(testFile, "fs.capability.lease.recoverable");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)isLeaseRecoverable).describedAs("path capabilities %s=%s in %s", new Object[]{"fs.capability.lease.recoverable", fileSystem.hasPathCapability(testFile, "fs.capability.lease.recoverable"), fileSystem})).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)fileSystem).describedAs("filesystem %s", new Object[]{fileSystem})).isInstanceOf(LeaseRecoverable.class);
            ((ObjectAssert)Assertions.assertThat((Object)fileSystem).describedAs("filesystem %s", new Object[]{fileSystem})).isInstanceOf(SafeMode.class);
        }
    }

    @Test
    public void testSafeMode() throws IOException {
        this.testSafeMode((ConsumerRaisingIOE<ViewDistributedFileSystem>)((ConsumerRaisingIOE)this::executeAssertionsWithSafeMode));
    }

    @Test
    public void testSafeModeWithDeprecatedAPIs() throws IOException {
        this.testSafeMode((ConsumerRaisingIOE<ViewDistributedFileSystem>)((ConsumerRaisingIOE)this::executeAssertionsWithDeprecatedAPIs));
    }

    private void testSafeMode(ConsumerRaisingIOE<ViewDistributedFileSystem> executeAssertionsFunction) throws IOException {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.getViewFsConfiguration()).numDataNodes(0).build();
             ViewDistributedFileSystem fileSystem = (ViewDistributedFileSystem)FileSystem.get((Configuration)cluster.getConfiguration(0));){
            executeAssertionsFunction.accept((Object)fileSystem);
        }
    }

    private SafeMode verifyAndGetSafeModeInstance(FileSystem fs) {
        ((ObjectAssert)Assertions.assertThat((Object)fs).describedAs("File system %s must be an instance of %s", new Object[]{fs, SafeMode.class.getClass()})).isInstanceOf(SafeMode.class);
        return (SafeMode)fs;
    }

    private void executeAssertionsWithSafeMode(ViewDistributedFileSystem fileSystem) throws IOException {
        SafeMode fsWithSafeMode = this.verifyAndGetSafeModeInstance((FileSystem)fileSystem);
        this.assertSafeModeStatus(fsWithSafeMode, SafeModeAction.GET, false, "Getting the status of safe mode before entering should be off.");
        this.assertSafeModeStatus(fsWithSafeMode, SafeModeAction.ENTER, true, "Entering Safe mode and safe mode turns on.");
        this.assertSafeModeStatus(fsWithSafeMode, SafeModeAction.GET, true, "Getting the status of safe mode after entering, safe mode should be on.");
        this.assertSafeModeStatus(fsWithSafeMode, SafeModeAction.LEAVE, false, "Leaving safe mode, and safe mode switches off.");
        this.assertSafeModeStatus(fsWithSafeMode, SafeModeAction.FORCE_EXIT, false, "Force exist safe mode at any time, safe mode should always switches off.");
    }

    private void executeAssertionsWithDeprecatedAPIs(ViewDistributedFileSystem fileSystem) throws IOException {
        this.assertSafeModeStatus(fileSystem, HdfsConstants.SafeModeAction.SAFEMODE_GET, false, "Getting the status of safe mode before entering should be off.");
        this.assertSafeModeStatus(fileSystem, HdfsConstants.SafeModeAction.SAFEMODE_ENTER, true, "Entering Safe mode and safe mode turns on.");
        this.assertSafeModeStatus(fileSystem, HdfsConstants.SafeModeAction.SAFEMODE_GET, true, "Getting the status of safe mode after entering, safe mode should be on.");
        this.assertSafeModeStatus(fileSystem, HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false, "Leaving safe mode, and safe mode switches off.");
        this.assertSafeModeStatus(fileSystem, HdfsConstants.SafeModeAction.SAFEMODE_FORCE_EXIT, false, "Force exist safe mode at any time, safe mode should always switches off.");
    }

    private void assertSafeModeStatus(SafeMode fsWithSafeMode, SafeModeAction action, boolean expectedStatus, String message) throws IOException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fsWithSafeMode.setSafeMode(action)).describedAs(message, new Object[0])).isEqualTo(expectedStatus);
    }

    private void assertSafeModeStatus(ViewDistributedFileSystem fileSystem, HdfsConstants.SafeModeAction action, boolean expectedStatus, String message) throws IOException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fileSystem.setSafeMode(action)).describedAs(message, new Object[0])).isEqualTo(expectedStatus);
    }

    private Configuration getViewFsConfiguration() {
        HdfsConfiguration conf = this.getTestConfiguration();
        URI defaultUri = URI.create(conf.get("fs.defaultFS"));
        conf.set("fs.viewfs.mounttable." + defaultUri.getHost() + ".linkFallback", defaultUri.toString());
        return conf;
    }
}

