/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.rx.internal.BackoffRetryUtility;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import rx.Observable;
import rx.Single;
import rx.functions.Func0;

public class ObservableHelper {
    public static <T> Single<T> inlineIfPossible(Func0<Single<T>> function, IRetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            return (Single)function.call();
        }
        return BackoffRetryUtility.executeRetry(function, retryPolicy);
    }

    public static <T> Observable<T> inlineIfPossibleAsObs(Func0<Observable<T>> function, IRetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            return Observable.defer(() -> (Observable)function.call());
        }
        return BackoffRetryUtility.executeRetry(() -> ((Observable)function.call()).toSingle(), retryPolicy).toObservable();
    }
}

