/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.hadoop.shaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.hadoop.shaded.com.sun.codemodel.JCodeModel;
import org.apache.hadoop.shaded.com.sun.codemodel.writer.FileCodeWriter;
import org.apache.hadoop.shaded.org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Annotator;
import org.apache.hadoop.shaded.org.jsonschema2pojo.AnnotatorFactory;
import org.apache.hadoop.shaded.org.jsonschema2pojo.ContentResolver;
import org.apache.hadoop.shaded.org.jsonschema2pojo.FileCodeWriterWithEncoding;
import org.apache.hadoop.shaded.org.jsonschema2pojo.GenerationConfig;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Language;
import org.apache.hadoop.shaded.org.jsonschema2pojo.RuleLogger;
import org.apache.hadoop.shaded.org.jsonschema2pojo.ScalaFileCodeWriter;
import org.apache.hadoop.shaded.org.jsonschema2pojo.SchemaGenerator;
import org.apache.hadoop.shaded.org.jsonschema2pojo.SchemaMapper;
import org.apache.hadoop.shaded.org.jsonschema2pojo.SchemaStore;
import org.apache.hadoop.shaded.org.jsonschema2pojo.SourceType;
import org.apache.hadoop.shaded.org.jsonschema2pojo.URLProtocol;
import org.apache.hadoop.shaded.org.jsonschema2pojo.exception.GenerationException;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RuleFactory;
import org.apache.hadoop.shaded.org.jsonschema2pojo.util.URLUtil;

public class Jsonschema2Pojo {
    public static void generate(GenerationConfig config, RuleLogger logger) throws IOException {
        Annotator annotator = Jsonschema2Pojo.getAnnotator(config);
        RuleFactory ruleFactory = Jsonschema2Pojo.createRuleFactory(config);
        ruleFactory.setAnnotator(annotator);
        ruleFactory.setGenerationConfig(config);
        ruleFactory.setLogger(logger);
        ruleFactory.setSchemaStore(new SchemaStore(Jsonschema2Pojo.createContentResolver(config)));
        SchemaMapper mapper = new SchemaMapper(ruleFactory, Jsonschema2Pojo.createSchemaGenerator(config));
        JCodeModel codeModel = new JCodeModel();
        if (config.isRemoveOldOutput()) {
            Jsonschema2Pojo.removeOldOutput(config.getTargetDirectory());
        }
        Iterator<URL> sources = config.getSource();
        while (sources.hasNext()) {
            URL source = sources.next();
            if (URLUtil.parseProtocol(source.toString()) == URLProtocol.FILE && URLUtil.getFileFromURL(source).isDirectory()) {
                Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, StringUtils.defaultString((String)config.getTargetPackage()), Arrays.asList(URLUtil.getFileFromURL(source).listFiles(config.getFileFilter())));
                continue;
            }
            mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(source, config), StringUtils.defaultString((String)config.getTargetPackage()), source);
        }
        if (config.getTargetDirectory().exists() || config.getTargetDirectory().mkdirs()) {
            FileCodeWriterWithEncoding resourcesWriter;
            FileCodeWriter sourcesWriter;
            if (config.getTargetLanguage() == Language.SCALA) {
                sourcesWriter = new ScalaFileCodeWriter(config.getTargetDirectory(), config.getOutputEncoding());
                resourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
                codeModel.build(sourcesWriter, resourcesWriter);
            } else {
                sourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
                resourcesWriter = new FileCodeWriterWithEncoding(config.getTargetDirectory(), config.getOutputEncoding());
                codeModel.build(sourcesWriter, resourcesWriter);
            }
        } else {
            throw new GenerationException("Could not create or access target directory " + config.getTargetDirectory().getAbsolutePath());
        }
    }

    private static ContentResolver createContentResolver(GenerationConfig config) {
        if (config.getSourceType() == SourceType.YAMLSCHEMA || config.getSourceType() == SourceType.YAML) {
            return new ContentResolver((JsonFactory)new YAMLFactory());
        }
        return new ContentResolver();
    }

    private static SchemaGenerator createSchemaGenerator(GenerationConfig config) {
        if (config.getSourceType() == SourceType.YAMLSCHEMA || config.getSourceType() == SourceType.YAML) {
            return new SchemaGenerator((JsonFactory)new YAMLFactory());
        }
        return new SchemaGenerator();
    }

    private static RuleFactory createRuleFactory(GenerationConfig config) {
        Class<? extends RuleFactory> clazz = config.getCustomRuleFactory();
        if (!RuleFactory.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The class name given as a rule factory  (" + clazz.getName() + ") does not refer to a class that implements " + RuleFactory.class.getName());
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Failed to create a rule factory from the given class. An exception was thrown on trying to create a new instance.", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to create a rule factory from the given class. It appears that we do not have access to this class - is both the class and its no-arg constructor marked public?", e);
        }
    }

    private static void generateRecursive(GenerationConfig config, SchemaMapper mapper, JCodeModel codeModel, String packageName, List<File> schemaFiles) throws IOException {
        Collections.sort(schemaFiles, config.getSourceSortOrder().getComparator());
        for (File child : schemaFiles) {
            if (child.isFile()) {
                mapper.generate(codeModel, Jsonschema2Pojo.getNodeName(child.toURI().toURL(), config), StringUtils.defaultString((String)packageName), child.toURI().toURL());
                continue;
            }
            Jsonschema2Pojo.generateRecursive(config, mapper, codeModel, Jsonschema2Pojo.childQualifiedName(packageName, child.getName()), Arrays.asList(child.listFiles(config.getFileFilter())));
        }
    }

    private static String childQualifiedName(String parentQualifiedName, String childSimpleName) {
        String safeChildName = childSimpleName.replaceAll("[^0-9a-zA-Z_$]", "_");
        return StringUtils.isEmpty((CharSequence)parentQualifiedName) ? safeChildName : parentQualifiedName + "." + safeChildName;
    }

    private static void removeOldOutput(File targetDirectory) {
        if (targetDirectory.exists()) {
            for (File f : targetDirectory.listFiles()) {
                Jsonschema2Pojo.delete(f);
            }
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void delete(File f) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                Jsonschema2Pojo.delete(child);
            }
        }
        f.delete();
    }

    private static Annotator getAnnotator(GenerationConfig config) {
        AnnotatorFactory factory = new AnnotatorFactory(config);
        return factory.getAnnotator(factory.getAnnotator(config.getAnnotationStyle()), factory.getAnnotator(config.getCustomAnnotator()));
    }

    public static String getNodeName(URL file, GenerationConfig config) {
        return Jsonschema2Pojo.getNodeName(file.toString(), config);
    }

    public static String getNodeName(String filePath, GenerationConfig config) {
        try {
            String fileName = FilenameUtils.getName((String)URLDecoder.decode(filePath, StandardCharsets.UTF_8.toString()));
            String[] extensions = config.getFileExtensions() == null ? new String[]{} : config.getFileExtensions();
            boolean extensionRemoved = false;
            for (int i = 0; i < extensions.length; ++i) {
                String extension = extensions[i];
                if (extension.length() == 0) continue;
                if (!extension.startsWith(".")) {
                    extension = "." + extension;
                }
                if (!fileName.endsWith(extension)) continue;
                fileName = StringUtils.removeEnd((String)fileName, (String)extension);
                extensionRemoved = true;
                break;
            }
            if (!extensionRemoved) {
                fileName = FilenameUtils.getBaseName((String)fileName);
            }
            return fileName;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Unable to generate node name from URL: %s", filePath), e);
        }
    }
}

