/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.spi.resilience;

import org.apache.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.ServiceUtils;
import org.apache.hadoop.shaded.org.ehcache.impl.config.resilience.DefaultResilienceStrategyConfiguration;
import org.apache.hadoop.shaded.org.ehcache.impl.config.resilience.DefaultResilienceStrategyProviderConfiguration;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.classes.ClassInstanceProvider;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.spi.resilience.RecoveryStore;
import org.apache.hadoop.shaded.org.ehcache.spi.resilience.ResilienceStrategy;
import org.apache.hadoop.shaded.org.ehcache.spi.resilience.ResilienceStrategyProvider;
import org.apache.hadoop.shaded.org.ehcache.spi.service.Service;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;

public class DefaultResilienceStrategyProvider
implements ResilienceStrategyProvider {
    private final ComponentProvider regularStrategies;
    private final ComponentProvider loaderWriterStrategies;

    protected DefaultResilienceStrategyProvider() {
        this(new DefaultResilienceStrategyProviderConfiguration());
    }

    protected DefaultResilienceStrategyProvider(DefaultResilienceStrategyProviderConfiguration configuration) {
        this.regularStrategies = new ComponentProvider(configuration.getDefaultConfiguration(), configuration);
        this.loaderWriterStrategies = new ComponentProvider(configuration.getDefaultLoaderWriterConfiguration(), configuration);
    }

    @Override
    public <K, V> ResilienceStrategy<K, V> createResilienceStrategy(String alias, CacheConfiguration<K, V> configuration, RecoveryStore<K> recoveryStore) {
        DefaultResilienceStrategyConfiguration config = ServiceUtils.findSingletonAmongst(DefaultResilienceStrategyConfiguration.class, configuration.getServiceConfigurations());
        return this.regularStrategies.create(alias, config, recoveryStore);
    }

    @Override
    public <K, V> ResilienceStrategy<K, V> createResilienceStrategy(String alias, CacheConfiguration<K, V> configuration, RecoveryStore<K> recoveryStore, CacheLoaderWriter<? super K, V> loaderWriter) {
        DefaultResilienceStrategyConfiguration config = ServiceUtils.findSingletonAmongst(DefaultResilienceStrategyConfiguration.class, configuration.getServiceConfigurations());
        return this.loaderWriterStrategies.create(alias, config, recoveryStore, loaderWriter);
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        this.regularStrategies.start(serviceProvider);
        try {
            this.loaderWriterStrategies.start(serviceProvider);
        }
        catch (Throwable t) {
            try {
                this.regularStrategies.stop();
            }
            catch (Throwable u) {
                t.addSuppressed(u);
            }
            throw t;
        }
    }

    @Override
    public void stop() {
        try {
            this.regularStrategies.stop();
        }
        finally {
            this.loaderWriterStrategies.stop();
        }
    }

    static class ComponentProvider
    extends ClassInstanceProvider<String, DefaultResilienceStrategyConfiguration, ResilienceStrategy<?, ?>> {
        private DefaultResilienceStrategyConfiguration defaultConfiguration;

        protected ComponentProvider(DefaultResilienceStrategyConfiguration dflt, DefaultResilienceStrategyProviderConfiguration factoryConfig) {
            super(factoryConfig, DefaultResilienceStrategyConfiguration.class);
            this.defaultConfiguration = dflt;
        }

        public <K, V> ResilienceStrategy<K, V> create(String alias, DefaultResilienceStrategyConfiguration config, RecoveryStore<K> recoveryStore, CacheLoaderWriter<? super K, V> loaderWriter) {
            if (config == null) {
                DefaultResilienceStrategyConfiguration preconfigured = (DefaultResilienceStrategyConfiguration)this.getPreconfigured(alias);
                if (preconfigured == null) {
                    return (ResilienceStrategy)this.newInstance(alias, (ServiceConfiguration<?, ?>)this.defaultConfiguration.bind(recoveryStore, loaderWriter));
                }
                return (ResilienceStrategy)this.newInstance(alias, (ServiceConfiguration<?, ?>)preconfigured.bind(recoveryStore, loaderWriter));
            }
            return (ResilienceStrategy)this.newInstance(alias, (ServiceConfiguration<?, ?>)config.bind(recoveryStore, loaderWriter));
        }

        public <K, V> ResilienceStrategy<K, V> create(String alias, DefaultResilienceStrategyConfiguration config, RecoveryStore<K> recoveryStore) {
            if (config == null) {
                DefaultResilienceStrategyConfiguration preconfigured = (DefaultResilienceStrategyConfiguration)this.getPreconfigured(alias);
                if (preconfigured == null) {
                    return (ResilienceStrategy)this.newInstance(alias, (ServiceConfiguration<?, ?>)this.defaultConfiguration.bind(recoveryStore));
                }
                return (ResilienceStrategy)this.newInstance(alias, (ServiceConfiguration<?, ?>)preconfigured.bind(recoveryStore));
            }
            return (ResilienceStrategy)this.newInstance(alias, (ServiceConfiguration<?, ?>)config.bind(recoveryStore));
        }
    }
}

