/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryDiffListFactory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffListBySkipList
implements DiffList<DirectoryWithSnapshotFeature.DirectoryDiff> {
    public static final Logger LOG = LoggerFactory.getLogger(DiffListBySkipList.class);
    private final List<SkipListNode> skipNodeList;
    private SkipListNode head;

    static String childrenDiff2String(DirectoryWithSnapshotFeature.ChildrenDiff diff) {
        if (diff == null) {
            return "null";
        }
        return "@" + Integer.toHexString(System.identityHashCode(diff));
    }

    static String skip2String(SkipListNode skipTo, DirectoryWithSnapshotFeature.ChildrenDiff diff) {
        return "->" + skipTo + ":diff=" + DiffListBySkipList.childrenDiff2String(diff);
    }

    public DiffListBySkipList(int capacity) {
        this.skipNodeList = new ArrayList<SkipListNode>(capacity);
        this.head = new SkipListNode(null, 0);
    }

    @Override
    public void addFirst(DirectoryWithSnapshotFeature.DirectoryDiff diff) {
        int nodeLevel = DirectoryDiffListFactory.randomLevel();
        Object[] nodePath = new SkipListNode[nodeLevel + 1];
        Arrays.fill(nodePath, this.head);
        SkipListNode newNode = new SkipListNode(diff, nodeLevel);
        for (int level = 0; level <= nodeLevel; ++level) {
            DirectoryWithSnapshotFeature.ChildrenDiff combined;
            SkipListNode nextNode;
            if (level > 0 && (nextNode = this.head.getSkipNode(level)) != null && (combined = DiffListBySkipList.combineDiff(newNode, nextNode, level)) != null) {
                newNode.setSkipDiff(combined, level);
            }
            newNode.setSkipTo(((SkipListNode)nodePath[level]).getSkipNode(level), level);
            ((SkipListNode)nodePath[level]).setSkipTo(newNode, level);
        }
        this.skipNodeList.add(0, newNode);
    }

    private SkipListNode[] findPreviousNodes(SkipListNode node, int nodeLevel) {
        int level;
        SkipListNode[] nodePath = new SkipListNode[nodeLevel + 1];
        SkipListNode cur = this.head;
        int headLevel = this.head.level();
        int n = level = headLevel < nodeLevel ? headLevel : nodeLevel;
        while (level >= 0) {
            while (cur.getSkipNode(level) != node) {
                cur = cur.getSkipNode(level);
            }
            nodePath[level] = cur;
            --level;
        }
        for (level = headLevel + 1; level <= nodeLevel; ++level) {
            nodePath[level] = this.head;
        }
        return nodePath;
    }

    @Override
    public boolean addLast(DirectoryWithSnapshotFeature.DirectoryDiff diff) {
        int nodeLevel = DirectoryDiffListFactory.randomLevel();
        SkipListNode[] nodePath = this.findPreviousNodes(null, nodeLevel);
        SkipListNode newNode = new SkipListNode(diff, nodeLevel);
        for (int level = 0; level <= nodeLevel; ++level) {
            DirectoryWithSnapshotFeature.ChildrenDiff combined;
            if (level > 0 && nodePath[level] != this.head && (combined = DiffListBySkipList.combineDiff(nodePath[level], newNode, level)) != null) {
                nodePath[level].setSkipDiff(combined, level);
            }
            nodePath[level].setSkipTo(newNode, level);
            newNode.setSkipTo(null, level);
        }
        return this.skipNodeList.add(newNode);
    }

    private static DirectoryWithSnapshotFeature.ChildrenDiff combineDiff(SkipListNode from, SkipListNode to, int level) {
        DirectoryWithSnapshotFeature.ChildrenDiff combined = null;
        DirectoryWithSnapshotFeature.ChildrenDiff first = null;
        SkipListNode cur = from;
        for (int i = level - 1; i >= 0; --i) {
            SkipListNode next;
            while (cur != to && (next = cur.getSkipNode(i)) != null) {
                if (first == null) {
                    first = cur.getChildrenDiff(i);
                } else {
                    if (combined == null) {
                        combined = new DirectoryWithSnapshotFeature.ChildrenDiff();
                        combined.combinePosterior(first, null);
                    }
                    combined.combinePosterior(cur.getChildrenDiff(i), null);
                }
                cur = next;
            }
        }
        return combined != null ? combined : first;
    }

    @Override
    public DirectoryWithSnapshotFeature.DirectoryDiff get(int index) {
        return this.skipNodeList.get(index).getDiff();
    }

    SkipListNode getSkipListNode(int i) {
        return this.skipNodeList.get(i);
    }

    @Override
    public DirectoryWithSnapshotFeature.DirectoryDiff remove(int index) {
        SkipListNode node = this.getNode(index);
        int headLevel = this.head.level();
        int nodeLevel = node.level();
        SkipListNode[] nodePath = this.findPreviousNodes(node, nodeLevel);
        for (int level = 0; level <= nodeLevel; ++level) {
            SkipListNode previous = nodePath[level];
            SkipListNode next = node.getSkipNode(level);
            if (level == 0) {
                if (next != null) {
                    previous.setSkipDiff4Target(next, 1, previous.getChildrenDiff(0));
                }
            } else if (previous != this.head) {
                if (next == null) {
                    previous.setSkipDiff(null, level);
                } else if (node.getChildrenDiff(level) != null) {
                    DirectoryWithSnapshotFeature.ChildrenDiff combined;
                    if (previous == nodePath[level - 1] && next == node.getSkipNode(level - 1)) {
                        combined = nodePath[level - 1].getChildrenDiff(level - 1);
                        previous.setSkipDiff4Target(next, level + 1, combined);
                    } else if (next == previous.getSkipNode(level + 1)) {
                        combined = previous.getChildrenDiff(level + 1);
                    } else {
                        combined = new DirectoryWithSnapshotFeature.ChildrenDiff();
                        combined.combinePosterior(previous.getChildrenDiff(level), null);
                        combined.combinePosterior(node.getChildrenDiff(level), null);
                    }
                    previous.setSkipDiff(combined, level);
                }
            }
            previous.setSkipTo(next, level);
        }
        if (nodeLevel == headLevel) {
            this.head.trim();
        }
        return this.skipNodeList.remove(index).getDiff();
    }

    @Override
    public boolean isEmpty() {
        return this.skipNodeList.isEmpty();
    }

    @Override
    public int size() {
        return this.skipNodeList.size();
    }

    @Override
    public Iterator<DirectoryWithSnapshotFeature.DirectoryDiff> iterator() {
        final Iterator<SkipListNode> i = this.skipNodeList.iterator();
        return new Iterator<DirectoryWithSnapshotFeature.DirectoryDiff>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public DirectoryWithSnapshotFeature.DirectoryDiff next() {
                return ((SkipListNode)i.next()).getDiff();
            }
        };
    }

    @Override
    public int binarySearch(int key) {
        return Collections.binarySearch(this.skipNodeList, key);
    }

    private SkipListNode getNode(int index) {
        return this.skipNodeList.get(index);
    }

    @Override
    public List<DirectoryWithSnapshotFeature.DirectoryDiff> getMinListForRange(int fromIndex, int toIndex, INodeDirectory dir) {
        ArrayList<DirectoryWithSnapshotFeature.DirectoryDiff> subList = new ArrayList<DirectoryWithSnapshotFeature.DirectoryDiff>();
        int toSnapshotId = this.get(toIndex - 1).getSnapshotId();
        SkipListNode current = this.getNode(fromIndex);
        while (current != null) {
            SkipListNode next = null;
            DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff = null;
            for (int level = current.level(); level >= 0; --level) {
                next = current.getSkipNode(level);
                if (next == null || next.getDiff().compareTo(toSnapshotId) > 0) continue;
                childrenDiff = current.getChildrenDiff(level);
                break;
            }
            DirectoryWithSnapshotFeature.DirectoryDiff curDiff = current.getDiff();
            subList.add(childrenDiff == null ? curDiff : new DirectoryWithSnapshotFeature.DirectoryDiff(curDiff.getSnapshotId(), dir, childrenDiff));
            if (current.getDiff().compareTo(toSnapshotId) == 0) break;
            current = next;
        }
        return subList;
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append(" head: ");
        this.head.appendTo(b);
        for (SkipListNode n : this.skipNodeList) {
            n.appendTo(b.append("\n  "));
        }
        return b.toString();
    }

    static final class SkipListNode
    implements Comparable<Integer> {
        private final DirectoryWithSnapshotFeature.DirectoryDiff diff;
        private SkipListNode next;
        private SkipDiff[] skips;

        SkipListNode(DirectoryWithSnapshotFeature.DirectoryDiff diff, int level) {
            this.diff = diff;
            this.skips = level > 0 ? new SkipDiff[level] : SkipDiff.EMPTY_ARRAY;
            for (int i = 0; i < this.skips.length; ++i) {
                this.skips[i] = new SkipDiff(null);
            }
        }

        public int level() {
            return this.skips.length;
        }

        void trim() {
            int n;
            for (n = this.skips.length - 1; n >= 0 && this.skips[n] == null; --n) {
            }
            if (++n < this.skips.length) {
                this.skips = n > 0 ? Arrays.copyOf(this.skips, n) : SkipDiff.EMPTY_ARRAY;
            }
        }

        public DirectoryWithSnapshotFeature.DirectoryDiff getDiff() {
            return this.diff;
        }

        @Override
        public int compareTo(Integer that) {
            return this.diff.compareTo(that);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SkipListNode that = (SkipListNode)o;
            return Objects.equals(this.diff, that.diff);
        }

        public int hashCode() {
            return Objects.hash(this.diff);
        }

        public void setSkipDiff(DirectoryWithSnapshotFeature.ChildrenDiff cDiff, int level) {
            Preconditions.checkArgument((level > 0 ? 1 : 0) != 0);
            this.resize(level);
            this.skips[level - 1].setDiff(cDiff);
        }

        void setSkipDiff4Target(SkipListNode target, int startLevel, DirectoryWithSnapshotFeature.ChildrenDiff childrenDiff) {
            for (int i = startLevel; i <= this.level(); ++i) {
                if (this.getSkipNode(i) != target) {
                    return;
                }
                this.setSkipDiff(childrenDiff, i);
            }
        }

        private void resize(int newLevel) {
            int i = this.skips.length;
            if (i < newLevel) {
                this.skips = Arrays.copyOf(this.skips, newLevel);
                while (i < newLevel) {
                    this.skips[i] = new SkipDiff(null);
                    ++i;
                }
            }
        }

        public void setSkipTo(SkipListNode node, int level) {
            if (level == 0) {
                this.next = node;
            } else {
                this.resize(level);
                this.skips[level - 1].setSkipTo(node);
            }
        }

        public DirectoryWithSnapshotFeature.ChildrenDiff getChildrenDiff(int level) {
            if (level == 0) {
                return this.diff != null ? this.diff.getChildrenDiff() : null;
            }
            return this.skips[level - 1].getDiff();
        }

        SkipListNode getSkipNode(int level) {
            return level == 0 ? this.next : (level <= this.skips.length ? this.skips[level - 1].getSkipTo() : null);
        }

        public String toString() {
            return this.diff != null ? "" + this.diff.getSnapshotId() : "?";
        }

        StringBuilder appendTo(StringBuilder b) {
            b.append(this).append(": ").append(DiffListBySkipList.skip2String(this.next, this.getChildrenDiff(0)));
            for (int i = 0; i < this.skips.length; ++i) {
                b.append(", ").append(this.skips[i]);
            }
            return b;
        }
    }

    private static class SkipDiff {
        static final SkipDiff[] EMPTY_ARRAY = new SkipDiff[0];
        private SkipListNode skipTo;
        private DirectoryWithSnapshotFeature.ChildrenDiff diff;

        SkipDiff(DirectoryWithSnapshotFeature.ChildrenDiff diff) {
            this.diff = diff;
        }

        public DirectoryWithSnapshotFeature.ChildrenDiff getDiff() {
            return this.diff;
        }

        public SkipListNode getSkipTo() {
            return this.skipTo;
        }

        public void setSkipTo(SkipListNode node) {
            this.skipTo = node;
        }

        public void setDiff(DirectoryWithSnapshotFeature.ChildrenDiff diff) {
            this.diff = diff;
        }

        public String toString() {
            return DiffListBySkipList.skip2String(this.skipTo, this.diff);
        }
    }
}

