/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressResolver;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Protocol;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

public class AddressSelector {
    private final IAddressResolver addressResolver;
    private final Protocol protocol;

    public AddressSelector(IAddressResolver addressResolver, Protocol protocol) {
        this.addressResolver = addressResolver;
        this.protocol = protocol;
    }

    public Single<List<URI>> resolveAllUriAsync(RxDocumentServiceRequest request, boolean includePrimary, boolean forceRefresh) {
        Single<List<AddressInformation>> allReplicaAddressesObs = this.resolveAddressesAsync(request, forceRefresh);
        return allReplicaAddressesObs.map(allReplicaAddresses -> allReplicaAddresses.stream().filter(a -> includePrimary || !a.isPrimary()).map(a -> HttpUtils.toURI((String)a.getPhysicalUri())).collect(Collectors.toList()));
    }

    public Single<URI> resolvePrimaryUriAsync(RxDocumentServiceRequest request, boolean forceAddressRefresh) {
        Single<List<AddressInformation>> replicaAddressesObs = this.resolveAddressesAsync(request, forceAddressRefresh);
        return replicaAddressesObs.flatMap(replicaAddresses -> {
            try {
                return Single.just((Object)AddressSelector.getPrimaryUri(request, replicaAddresses));
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
        });
    }

    public static URI getPrimaryUri(RxDocumentServiceRequest request, List<AddressInformation> replicaAddresses) throws GoneException {
        AddressInformation primaryAddress = null;
        if (request.getDefaultReplicaIndex() != null) {
            int defaultReplicaIndex = request.getDefaultReplicaIndex();
            if (defaultReplicaIndex >= 0 && defaultReplicaIndex < replicaAddresses.size()) {
                primaryAddress = replicaAddresses.get(defaultReplicaIndex);
            }
        } else {
            primaryAddress = replicaAddresses.stream().filter(address -> address.isPrimary() && !address.getPhysicalUri().contains("[")).findAny().orElse(null);
        }
        if (primaryAddress == null) {
            throw new GoneException(String.format("The requested resource is no longer available at the server. Returned addresses are {%s}", String.join((CharSequence)",", replicaAddresses.stream().map(address -> address.getPhysicalUri()).collect(Collectors.toList()))), null);
        }
        return HttpUtils.toURI((String)primaryAddress.getPhysicalUri());
    }

    public Single<List<AddressInformation>> resolveAddressesAsync(RxDocumentServiceRequest request, boolean forceAddressRefresh) {
        Single resolvedAddressesObs = this.addressResolver.resolveAsync(request, forceAddressRefresh).map(addresses -> Arrays.stream(addresses).filter(address -> !Strings.isNullOrEmpty((String)address.getPhysicalUri()) && Strings.areEqualIgnoreCase((String)address.getProtocolScheme(), (String)this.protocol.scheme())).collect(Collectors.toList()));
        return resolvedAddressesObs.map(resolvedAddresses -> {
            List r = resolvedAddresses.stream().filter(address -> !address.isPublic()).collect(Collectors.toList());
            if (r.size() > 0) {
                return r;
            }
            return resolvedAddresses.stream().filter(address -> address.isPublic()).collect(Collectors.toList());
        });
    }
}

