/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.TreePath;

public class ResourceUsageMetrics
implements Writable,
DeepCompare {
    private long cumulativeCpuUsage;
    private long virtualMemoryUsage;
    private long physicalMemoryUsage;
    private long heapUsage;

    public long getCumulativeCpuUsage() {
        return this.cumulativeCpuUsage;
    }

    public void setCumulativeCpuUsage(long usage) {
        this.cumulativeCpuUsage = usage;
    }

    public long getVirtualMemoryUsage() {
        return this.virtualMemoryUsage;
    }

    public void setVirtualMemoryUsage(long usage) {
        this.virtualMemoryUsage = usage;
    }

    public long getPhysicalMemoryUsage() {
        return this.physicalMemoryUsage;
    }

    public void setPhysicalMemoryUsage(long usage) {
        this.physicalMemoryUsage = usage;
    }

    public long getHeapUsage() {
        return this.heapUsage;
    }

    public void setHeapUsage(long usage) {
        this.heapUsage = usage;
    }

    public int size() {
        int size = 0;
        size += WritableUtils.getVIntSize((long)this.cumulativeCpuUsage);
        size += WritableUtils.getVIntSize((long)this.virtualMemoryUsage);
        size += WritableUtils.getVIntSize((long)this.physicalMemoryUsage);
        return size += WritableUtils.getVIntSize((long)this.heapUsage);
    }

    public void readFields(DataInput in) throws IOException {
        this.cumulativeCpuUsage = WritableUtils.readVLong((DataInput)in);
        this.virtualMemoryUsage = WritableUtils.readVLong((DataInput)in);
        this.physicalMemoryUsage = WritableUtils.readVLong((DataInput)in);
        this.heapUsage = WritableUtils.readVLong((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVLong((DataOutput)out, (long)this.cumulativeCpuUsage);
        WritableUtils.writeVLong((DataOutput)out, (long)this.virtualMemoryUsage);
        WritableUtils.writeVLong((DataOutput)out, (long)this.physicalMemoryUsage);
        WritableUtils.writeVLong((DataOutput)out, (long)this.heapUsage);
    }

    private static void compareMetric(long m1, long m2, TreePath loc) throws DeepInequalityException {
        if (m1 != m2) {
            throw new DeepInequalityException("Value miscompared:" + loc.toString(), loc);
        }
    }

    private static void compareSize(ResourceUsageMetrics m1, ResourceUsageMetrics m2, TreePath loc) throws DeepInequalityException {
        if (m1.size() != m2.size()) {
            throw new DeepInequalityException("Size miscompared: " + loc.toString(), loc);
        }
    }

    @Override
    public void deepCompare(DeepCompare other, TreePath loc) throws DeepInequalityException {
        if (!(other instanceof ResourceUsageMetrics)) {
            throw new DeepInequalityException("Comparand has wrong type", loc);
        }
        ResourceUsageMetrics metrics2 = (ResourceUsageMetrics)other;
        ResourceUsageMetrics.compareMetric(this.getCumulativeCpuUsage(), metrics2.getCumulativeCpuUsage(), new TreePath(loc, "cumulativeCpu"));
        ResourceUsageMetrics.compareMetric(this.getVirtualMemoryUsage(), metrics2.getVirtualMemoryUsage(), new TreePath(loc, "virtualMemory"));
        ResourceUsageMetrics.compareMetric(this.getPhysicalMemoryUsage(), metrics2.getPhysicalMemoryUsage(), new TreePath(loc, "physicalMemory"));
        ResourceUsageMetrics.compareMetric(this.getHeapUsage(), metrics2.getHeapUsage(), new TreePath(loc, "heapUsage"));
        ResourceUsageMetrics.compareSize(this, metrics2, new TreePath(loc, "size"));
    }
}

