/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import javax.annotation.Nonnull;
import org.testng.ISuite;
import org.testng.SuiteResultCounts;
import org.testng.SuiteRunner;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.Utils;
import org.testng.internal.invokers.SuiteRunnerMap;
import org.testng.thread.IWorker;
import org.testng.xml.XmlSuite;

public class SuiteRunnerWorker
implements IWorker<ISuite> {
    private static final String LINE = "\n===============================================\n";
    private final SuiteRunner m_suiteRunner;
    private final Integer m_verbose;
    private final String m_defaultSuiteName;
    private final SuiteRunnerMap m_suiteRunnerMap;

    public SuiteRunnerWorker(ISuite suiteRunner, SuiteRunnerMap suiteRunnerMap, int verbose, String defaultSuiteName) {
        this.m_suiteRunnerMap = suiteRunnerMap;
        this.m_suiteRunner = (SuiteRunner)suiteRunner;
        this.m_verbose = verbose;
        this.m_defaultSuiteName = defaultSuiteName;
    }

    private void runSuite(SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        if (this.m_verbose > 0) {
            String allFiles = "  " + (xmlSuite.getFileName() != null ? xmlSuite.getFileName() : this.m_defaultSuiteName) + "\n";
            Utils.log("TestNG", 0, "Running:\n" + allFiles);
        }
        SuiteRunner suiteRunner = (SuiteRunner)suiteRunnerMap.get(xmlSuite);
        suiteRunner.run();
        if (xmlSuite.getVerbose() > 0) {
            SuiteResultCounts counts = new SuiteResultCounts();
            counts.calculateResultCounts(xmlSuite, suiteRunnerMap);
            StringBuilder bufLog = new StringBuilder(LINE).append(xmlSuite.getName());
            bufLog.append("\nTotal tests run: ").append(counts.m_total).append(", Passes: ").append(counts.m_passes).append(", Failures: ").append(counts.m_failed).append(", Skips: ").append(counts.m_skipped);
            if (counts.m_retries > 0) {
                bufLog.append(", Retries: ").append(counts.m_retries);
            }
            if (counts.m_confFailures > 0 || counts.m_confSkips > 0) {
                bufLog.append("\nConfiguration Failures: ").append(counts.m_confFailures).append(", Skips: ").append(counts.m_confSkips);
            }
            bufLog.append(LINE);
            System.out.println(bufLog);
        }
    }

    @Override
    public void run() {
        this.runSuite(this.m_suiteRunnerMap, this.m_suiteRunner.getXmlSuite());
    }

    @Override
    public int compareTo(@Nonnull IWorker<ISuite> arg0) {
        return 0;
    }

    @Override
    public List<ISuite> getTasks() {
        List<ISuite> suiteRunnerList = Lists.newArrayList();
        suiteRunnerList.add(this.m_suiteRunner);
        return suiteRunnerList;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_suiteRunner.getName()).toString();
    }

    @Override
    public long getTimeOut() {
        return this.m_suiteRunner.getXmlSuite().getTimeOut(Long.MAX_VALUE);
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

