/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.listener.AsyncQueueListener;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.EventListenerConfig;
import org.apache.gravitino.listener.EventListenerPluginWrapper;
import org.apache.gravitino.listener.api.EventListenerPlugin;
import org.apache.gravitino.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerManager {
    private static final Logger LOG = LoggerFactory.getLogger(EventListenerManager.class);
    public static final String GRAVITINO_EVENT_LISTENER_PREFIX = "gravitino.eventListener.";
    public static final String GRAVITINO_EVENT_LISTENER_NAMES = "names";
    public static final String GRAVITINO_EVENT_LISTENER_CLASS = "class";
    public static final String GRAVITINO_EVENT_LISTENER_QUEUE_CAPACITY = "queueCapacity";
    static final String GRAVITINO_EVENT_LISTENER_DISPATCHER_JOIN_SECONDS = "dispatcherJoinSeconds";
    private static final Splitter splitter = Splitter.on((String)",");
    private static final Joiner DOT = Joiner.on((String)".");
    private int queueCapacity;
    private int dispatcherJoinSeconds;
    private List<EventListenerPlugin> eventListeners;

    public void init(Map<String, String> properties) {
        EventListenerConfig config = new EventListenerConfig(properties);
        this.queueCapacity = config.get(EventListenerConfig.QUEUE_CAPACITY);
        this.dispatcherJoinSeconds = config.get(EventListenerConfig.DISPATCHER_JOIN_SECONDS);
        String eventListenerNames = config.get(EventListenerConfig.LISTENER_NAMES);
        Map<String, EventListenerPlugin> userEventListenerPlugins = splitter.omitEmptyStrings().trimResults().splitToStream((CharSequence)eventListenerNames).collect(Collectors.toMap(listenerName -> listenerName, listenerName -> this.loadUserEventListenerPlugin((String)listenerName, MapUtils.getPrefixMap((Map)properties, (String)DOT.join(listenerName, (Object)"", new Object[0]))), (existingValue, newValue) -> {
            throw new IllegalStateException("Duplicate event listener name detected: " + existingValue);
        }));
        this.eventListeners = this.assembleEventListeners(userEventListenerPlugins);
    }

    public void start() {
        this.eventListeners.stream().forEach(listener -> listener.start());
    }

    public void stop() {
        this.eventListeners.stream().forEach(listener -> listener.stop());
    }

    public EventBus createEventBus() {
        return new EventBus(this.eventListeners);
    }

    public void addEventListener(String listenerName, EventListenerPlugin listener) {
        this.eventListeners.add(new EventListenerPluginWrapper(listenerName, listener));
    }

    private List<EventListenerPlugin> assembleEventListeners(Map<String, EventListenerPlugin> userEventListeners) {
        ArrayList<EventListenerPlugin> sharedQueueListeners = new ArrayList<EventListenerPlugin>();
        List<EventListenerPlugin> listeners = userEventListeners.entrySet().stream().map(entrySet -> {
            String listenerName = (String)entrySet.getKey();
            EventListenerPlugin listener = (EventListenerPlugin)entrySet.getValue();
            switch (listener.mode()) {
                case SYNC: {
                    return new EventListenerPluginWrapper(listenerName, listener);
                }
                case ASYNC_ISOLATED: {
                    return new AsyncQueueListener((List<EventListenerPlugin>)ImmutableList.of((Object)new EventListenerPluginWrapper(listenerName, listener)), listenerName, this.queueCapacity, this.dispatcherJoinSeconds);
                }
                case ASYNC_SHARED: {
                    sharedQueueListeners.add(new EventListenerPluginWrapper(listenerName, listener));
                    return null;
                }
            }
            throw new RuntimeException("Unexpected listener mode:" + (Object)((Object)listener.mode()));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!sharedQueueListeners.isEmpty()) {
            listeners.add(new AsyncQueueListener(sharedQueueListeners, "default", this.queueCapacity, this.dispatcherJoinSeconds));
        }
        return listeners;
    }

    private EventListenerPlugin loadUserEventListenerPlugin(String listenerName, Map<String, String> config) {
        LOG.info("EventListener:{}, config:{}.", (Object)listenerName, config);
        String className = config.get(GRAVITINO_EVENT_LISTENER_CLASS);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)className), (Object)String.format("EventListener:%s, %s%s.%s is not set in configuration.", listenerName, GRAVITINO_EVENT_LISTENER_PREFIX, listenerName, GRAVITINO_EVENT_LISTENER_CLASS));
        try {
            EventListenerPlugin listenerPlugin = (EventListenerPlugin)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            listenerPlugin.init(config);
            return listenerPlugin;
        }
        catch (Exception e) {
            LOG.error("Failed to create and initialize event listener {}, className: {}.", new Object[]{listenerName, className, e});
            throw new RuntimeException(e);
        }
    }
}

