/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Bucket;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;
import org.apache.geode.internal.cache.partitioned.rebalance.model.MemberRollup;

public class BucketRollup
extends Bucket {
    private final Map<String, Bucket> colocatedBuckets = new HashMap<String, Bucket>();

    BucketRollup(int id) {
        super(id);
    }

    void addColocatedBucket(String region, Bucket b) {
        if (!this.getColocatedBuckets().containsKey(region)) {
            this.getColocatedBuckets().put(region, b);
            this.changeLoad(b.getLoad());
            this.changePrimaryLoad(b.getPrimaryLoad());
            this.changeBytes(b.getBytes());
            this.addOfflineMembers(b.getOfflineMembers());
            for (Member member : this.getMembersHosting()) {
                MemberRollup rollup = (MemberRollup)member;
                float primaryLoad = 0.0f;
                if (this.getPrimary() == member) {
                    primaryLoad = b.getPrimaryLoad();
                }
                rollup.updateLoad(b.getLoad(), primaryLoad, b.getBytes());
            }
        }
    }

    @Override
    public boolean addMember(Member targetMember) {
        if (super.addMember(targetMember)) {
            MemberRollup memberRollup = (MemberRollup)targetMember;
            for (Map.Entry<String, Bucket> entry : this.getColocatedBuckets().entrySet()) {
                String region = entry.getKey();
                Bucket bucket = entry.getValue();
                Member member = memberRollup.getColocatedMembers().get(region);
                if (member == null) continue;
                bucket.addMember(member);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeMember(Member targetMember) {
        if (super.removeMember(targetMember)) {
            MemberRollup memberRollup = (MemberRollup)targetMember;
            for (Map.Entry<String, Bucket> entry : this.getColocatedBuckets().entrySet()) {
                String region = entry.getKey();
                Bucket bucket = entry.getValue();
                Member member = memberRollup.getColocatedMembers().get(region);
                if (member == null) continue;
                bucket.removeMember(member);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPrimary(Member targetMember, float primaryLoad) {
        super.setPrimary(targetMember, primaryLoad);
        if (targetMember != null) {
            MemberRollup memberRollup = (MemberRollup)targetMember;
            for (Map.Entry<String, Bucket> entry : this.getColocatedBuckets().entrySet()) {
                String region = entry.getKey();
                Bucket bucket = entry.getValue();
                Member member = memberRollup.getColocatedMembers().get(region);
                if (member == null) continue;
                bucket.setPrimary(member, primaryLoad);
            }
        }
    }

    Map<String, Bucket> getColocatedBuckets() {
        return this.colocatedBuckets;
    }
}

