/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;

public class LockGrantorId {
    public static final int ROLLOVER_MARGIN = Integer.getInteger("gemfire.DLockService.LockGrantorId.rolloverMargin", 10000);
    private final DistributionManager dm;
    private final InternalDistributedMember lockGrantorMember;
    private final long lockGrantorVersion;
    private final int lockGrantorSerialNumber;

    public LockGrantorId(DistributionManager dm, InternalDistributedMember lockGrantorMember, long lockGrantorVersion, int lockGrantorSerialNumber) {
        if (lockGrantorMember == null) {
            throw new NullPointerException("lockGrantorMember is null");
        }
        this.dm = dm;
        this.lockGrantorMember = lockGrantorMember;
        this.lockGrantorVersion = lockGrantorVersion;
        this.lockGrantorSerialNumber = lockGrantorSerialNumber;
    }

    public InternalDistributedMember getLockGrantorMember() {
        return this.lockGrantorMember;
    }

    public long getLockGrantorVersion() {
        return this.lockGrantorVersion;
    }

    public int getLockGrantorSerialNumber() {
        return this.lockGrantorSerialNumber;
    }

    public boolean hasLockGrantorVersion() {
        return this.lockGrantorVersion > -1L;
    }

    public boolean sameAs(LockGrantorId otherLockGrantorId) {
        if (otherLockGrantorId == null) {
            return false;
        }
        return this.sameAs(otherLockGrantorId.lockGrantorMember, otherLockGrantorId.lockGrantorVersion, otherLockGrantorId.lockGrantorSerialNumber);
    }

    public boolean isNewerThan(LockGrantorId otherLockGrantorId) {
        boolean isNewer;
        if (otherLockGrantorId == null) {
            return true;
        }
        boolean bl = isNewer = this.lockGrantorVersion > otherLockGrantorId.getLockGrantorVersion();
        if (!isNewer && this.lockGrantorMember.equals(otherLockGrantorId.getLockGrantorMember())) {
            int otherGrantorSerialNumber = otherLockGrantorId.getLockGrantorSerialNumber();
            boolean serialRolled = this.lockGrantorSerialNumber > ROLLOVER_MARGIN && otherGrantorSerialNumber < 0;
            isNewer = serialRolled || this.lockGrantorSerialNumber > otherGrantorSerialNumber;
        }
        return isNewer;
    }

    public boolean sameAs(InternalDistributedMember someLockGrantorMember, long someLockGrantorVersion, int someLockGrantorSerialNumber) {
        if (someLockGrantorMember == null) {
            throw new IllegalStateException("someLockGrantorId must not be null");
        }
        return someLockGrantorMember.equals(this.lockGrantorMember) && someLockGrantorVersion == this.lockGrantorVersion && someLockGrantorSerialNumber == this.lockGrantorSerialNumber;
    }

    public boolean isLocal() {
        return this.dm.getId().equals(this.lockGrantorMember);
    }

    public boolean isLocal(int dlsSerialNumber) {
        return this.lockGrantorSerialNumber == dlsSerialNumber && this.dm.getId().equals(this.lockGrantorMember);
    }

    public boolean isRemote() {
        return !this.dm.getId().equals(this.lockGrantorMember);
    }

    public String toString() {
        return "[LockGrantorId: lockGrantorMember=" + this.lockGrantorMember + ", lockGrantorVersion=" + this.lockGrantorVersion + ", lockGrantorSerialNumber=" + this.lockGrantorSerialNumber + "]";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof LockGrantorId)) {
            return false;
        }
        LockGrantorId that = (LockGrantorId)other;
        if (!(this.lockGrantorMember == that.lockGrantorMember || this.lockGrantorMember != null && this.lockGrantorMember.equals(that.lockGrantorMember))) {
            return false;
        }
        if (this.lockGrantorVersion != that.lockGrantorVersion) {
            return false;
        }
        return this.lockGrantorSerialNumber == that.lockGrantorSerialNumber;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.lockGrantorMember == null ? 0 : this.lockGrantorMember.hashCode());
        result = 37 * result + (int)(this.lockGrantorVersion ^ this.lockGrantorVersion >>> 32);
        result = 37 * result + this.lockGrantorSerialNumber;
        return result;
    }
}

